/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.ui;

import com.tridium.ui.theme.Theme;
import com.tridium.util.TimeFormat;
import com.tridium.workbench.util.BDatePickerCalendar;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BSpinnerButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BDayOfYearFE
extends BWbFieldEditor {
    public static final Action increment = BDayOfYearFE.newAction((int)0, null);
    public static final Action decrement = BDayOfYearFE.newAction((int)0, null);
    public static final Action showDatePicker = BDayOfYearFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BDayOfYearFE.class);
    public static final BImage calendarIcon = BImage.make((String)"module://icons/x16/calendar.png");
    protected Field[] fields = new Field[0];
    BSpinnerButton spinner = new BSpinnerButton();
    BWidget datePickerButton;
    int selection = 0;
    double charWidth;
    boolean paintNull;
    double prefHeight;
    static final double textViewFix = 4.0;
    MonthField month;
    DayField day;

    public void increment() {
        this.invoke(increment, null, null);
    }

    public void decrement() {
        this.invoke(decrement, null, null);
    }

    public void showDatePicker() {
        this.invoke(showDatePicker, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDayOfYearFE() {
        this.add("spinner", (BValue)this.spinner, 6);
        this.linkTo("incrementLink", (BComponent)this.spinner, (Slot)BSpinnerButton.increment, (Slot)increment);
        this.linkTo("decrementLink", (BComponent)this.spinner, (Slot)BSpinnerButton.decrement, (Slot)decrement);
    }

    protected void addDatePicker() {
        if (this.get("picker") != null) {
            return;
        }
        this.datePickerButton = new BButton(calendarIcon);
        ((BButton)this.datePickerButton).setFocusTraversable(false);
        ((BButton)this.datePickerButton).setButtonStyle(BButtonStyle.toolBar);
        this.add("picker", (BValue)this.datePickerButton);
        this.linkTo("editButtonLink", (BComponent)this.datePickerButton, (Slot)BButton.actionPerformed, (Slot)showDatePicker);
    }

    protected void doSetReadonly(boolean readonly) {
        this.relayout();
    }

    public void computePreferredSize() {
        BFont font = Theme.textField().getFont();
        this.charWidth = font.width("0");
        double tw = 0.0;
        for (int i = 0; i < this.fields.length; ++i) {
            tw += this.charWidth * (double)this.fields[i].length();
        }
        BInsets insets = Theme.textField().getInsets();
        double pw = tw + insets.left + insets.right + 13.0;
        double ph = font.getHeight() - 4.0 + insets.top + insets.bottom;
        if (this.datePickerButton != null && !this.isReadonly()) {
            this.datePickerButton.computePreferredSize();
            pw += this.datePickerButton.getPreferredWidth() + 5.0;
            ph = Math.max(ph, this.datePickerButton.getPreferredHeight());
        }
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        this.computePreferredSize();
        BFont font = Theme.textField().getFont();
        BInsets insets = Theme.textField().getInsets();
        this.charWidth = font.width("0");
        this.prefHeight = this.getPreferredHeight();
        if (this.isReadonly()) {
            this.spinner.setVisible(false);
            this.spinner.setBounds(-1.0, -1.0, 0.0, 0.0);
            if (this.datePickerButton != null) {
                this.datePickerButton.setVisible(false);
                this.datePickerButton.setBounds(-1.0, -1.0, 0.0, 0.0);
            }
        } else {
            double w = this.getWidth();
            double h = this.getHeight();
            double sw = 13.0;
            double dpw = 0.0;
            double th = font.getHeight() - 4.0 + insets.top + insets.bottom;
            if (this.datePickerButton != null) {
                this.datePickerButton.computePreferredSize();
                dpw = this.datePickerButton.getPreferredWidth();
                this.datePickerButton.setVisible(true);
                this.datePickerButton.setBounds(w - dpw, 0.0, dpw, Math.min(h, this.prefHeight));
            }
            this.spinner.setVisible(true);
            this.spinner.setBounds(w - sw - (dpw == 0.0 ? 0.0 : dpw + 5.0), 0.0, sw, Math.min(th, this.prefHeight));
        }
    }

    int fieldAt(double x, double y) {
        int pos = (int)(x / this.charWidth);
        int f1 = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            int f2 = f1 + this.fields[i].length();
            if (f1 <= pos && pos <= f2) {
                return i;
            }
            f1 = f2;
        }
        return -1;
    }

    public void paint(Graphics g) {
        BFont font = Theme.textField().getFont();
        BInsets insets = Theme.textField().getInsets();
        double w = this.getWidth();
        double tw = w - this.spinner.getWidth();
        double th = font.getHeight() - 4.0 + insets.top + insets.bottom;
        boolean focus = this.hasFocus();
        if (this.datePickerButton != null) {
            tw -= this.datePickerButton.getWidth() + 5.0;
        }
        BBrush fg = this.isReadonly() ? Theme.widget().getControlForeground() : Theme.widget().getWindowForeground();
        BBrush bg = this.isReadonly() ? Theme.widget().getControlBackground() : Theme.widget().getWindowBackground();
        BBrush fgSel = Theme.widget().getSelectionForeground();
        BBrush bgSel = Theme.widget().getSelectionBackground();
        g.setFont(font);
        g.setBrush(bg);
        g.fillRect(0.0, 0.0, tw, th);
        g.setBrush(fg);
        double tx = insets.left;
        double ty = th - insets.bottom - 2.0;
        if (this.paintNull && this.isReadonly()) {
            g.drawString("null", tx, ty);
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                Field f = this.fields[i];
                String str = f.string();
                if (str == null) {
                    str = "?";
                }
                double strWidth = this.charWidth * (double)str.length();
                if (i == this.selection && focus) {
                    g.setBrush(bgSel);
                    g.fillRect(tx, insets.top, strWidth, th - insets.top - insets.bottom);
                    g.setBrush(fgSel);
                }
                g.drawString(str, tx, ty);
                tx += strWidth;
                g.setBrush(fg);
            }
        }
        Theme.textField().paintBorder(g, (BWidget)this, tw, th);
        this.paintChildren(g);
    }

    public void mousePressed(BMouseEvent event) {
        super.mousePressed(event);
        if (this.isReadonly()) {
            return;
        }
        this.requestFocus();
        int f = this.fieldAt(event.getX(), event.getY());
        if (f != -1 && this.fields[f].isEditable()) {
            this.setSelection(f);
        }
    }

    public void keyTyped(BKeyEvent event) {
        char key = event.getKeyChar();
        if (key == '\n' || key == '\r') {
            this.fireActionPerformed(new BWidgetEvent(2, (BWidget)this));
            event.consume();
        } else if (this.fields[this.selection].keyTyped(key)) {
            event.consume();
        }
    }

    public void keyPressed(BKeyEvent event) {
        if (event.getModifiers() != 0) {
            return;
        }
        int s = this.selection;
        switch (event.getKeyCode()) {
            case 39: {
                do {
                    if (++s < this.fields.length) continue;
                    s = 0;
                } while (!this.fields[s].isEditable());
                this.setSelection(s);
                event.consume();
                break;
            }
            case 37: {
                do {
                    if (--s >= 0) continue;
                    s = this.fields.length - 1;
                } while (!this.fields[s].isEditable());
                this.setSelection(s);
                event.consume();
                break;
            }
            case 38: {
                this.doIncrement();
                event.consume();
                break;
            }
            case 40: {
                this.doDecrement();
                event.consume();
            }
        }
    }

    public boolean isFocusTraversable() {
        return !this.isReadonly();
    }

    public void focusGained(BFocusEvent event) {
        this.repaint();
    }

    public void focusLost(BFocusEvent event) {
        this.repaint();
    }

    public void doIncrement() {
        this.fields[this.selection].increment();
    }

    public void doDecrement() {
        this.fields[this.selection].decrement();
    }

    public void doShowDatePicker() {
        Field month = null;
        Field day = null;
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] instanceof MonthField) {
                month = this.fields[i];
            }
            if (!(this.fields[i] instanceof DayField)) continue;
            day = this.fields[i];
        }
        if (month == null || day == null) {
            return;
        }
        BDatePickerCalendar picker = BDatePickerCalendar.dialog((BWidget)this, (int)2010, (BMonth)BMonth.make((int)month.value));
        if (picker == null) {
            return;
        }
        month.set(picker.month.getOrdinal());
        day.set(picker.day);
        this.setModified();
        this.repaint();
    }

    protected void doLoadValue(BObject value, Context cx) {
        BAbsTime abs = (BAbsTime)value;
        if (abs.isNull() && this.isReadonly()) {
            this.fields = new Field[]{new LabelField("null")};
            return;
        }
        ArrayList<Field> v = new ArrayList<Field>();
        int[] pattern = TimeFormat.pattern((Context)cx);
        this.addDatePicker();
        block5: for (int i = 0; i < pattern.length; ++i) {
            switch (pattern[i]) {
                case 3: 
                case 4: {
                    this.month = new MonthField();
                    this.month.set(abs.getMonth().getOrdinal());
                    v.add(this.month);
                    continue block5;
                }
                case 5: {
                    this.month = new MonthTagField();
                    this.month.set(abs.getMonth().getOrdinal());
                    v.add(this.month);
                    continue block5;
                }
                case 6: 
                case 7: {
                    this.day = new DayField();
                    this.day.set(abs.getDay());
                    v.add(this.day);
                    v.add(new LabelField("-"));
                    continue block5;
                }
            }
        }
        this.fields = v.toArray(new Field[v.size()]);
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        GregorianCalendar c = new GregorianCalendar();
        for (int i = 0; i < this.fields.length; ++i) {
            Field f = this.fields[i];
            if (f instanceof MonthField) {
                c.set(2, f.value);
            }
            if (!(f instanceof DayField)) continue;
            c.set(5, f.value);
        }
        return BAbsTime.make((long)c.getTime().getTime());
    }

    void setSelection(int f) {
        if (!this.fields[f].isEditable()) {
            throw new IllegalStateException();
        }
        this.fields[this.selection].typeCount = 0;
        this.selection = f;
        this.repaint();
    }

    protected void fieldModified(Field field) {
        if (field == this.month && this.month != null) {
            BMonth mon = BMonth.make((int)this.month.value);
            int daysInMonth = BAbsTime.getDaysInMonth((int)2010, (BMonth)mon);
            this.day.setMax(daysInMonth);
        }
        this.setModified();
        this.repaint();
    }

    public class LabelField
    extends Field {
        LabelField(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            this.string = s;
        }

        @Override
        int length() {
            return this.string.length();
        }

        @Override
        boolean isEditable() {
            return false;
        }

        @Override
        int max() {
            return 1;
        }
    }

    public class MonthTagField
    extends MonthField {
        @Override
        int length() {
            return 3;
        }

        @Override
        int max() {
            return 11;
        }

        @Override
        public void set(int v) {
            BMonth m = BMonth.make((int)v);
            this.value = v;
            this.string = m.getShortDisplayTag(null);
            while (this.string.length() < 3) {
                this.string = this.string + " ";
            }
            if (this.string.length() > 3) {
                this.string = this.string.substring(0, 3);
            }
            if (BDayOfYearFE.this != null) {
                this.fieldModified();
            }
        }

        @Override
        boolean keyTyped(int key) {
            return false;
        }
    }

    public class MonthField
    extends Field {
        @Override
        int length() {
            return 2;
        }

        @Override
        int max() {
            return 11;
        }

        @Override
        public void set(int v) {
            this.value = v;
            this.string = String.valueOf(v + 1);
            for (int i = this.string.length(); i < this.length(); ++i) {
                this.string = "0" + this.string;
            }
            if (BDayOfYearFE.this != null) {
                this.fieldModified();
            }
        }

        @Override
        boolean keyTyped(int key) {
            if (Character.isDigit((char)key)) {
                int v;
                int k = key - 48;
                if (this.typeCount == 0) {
                    v = k;
                } else {
                    int pow = 1;
                    for (int i = 0; i < this.length() - 1; ++i) {
                        pow *= 10;
                    }
                    v = (this.value + 1) % pow * 10 + k;
                }
                if (v > 0 && v <= this.max() + 1) {
                    this.set(v - 1);
                }
                ++this.typeCount;
                return true;
            }
            return false;
        }
    }

    public class DayField
    extends Field {
        int maxDay;

        public DayField() {
            this.maxDay = 31;
        }

        @Override
        int length() {
            return 2;
        }

        @Override
        int min() {
            return 1;
        }

        @Override
        int max() {
            return this.maxDay;
        }

        void setMax(int newMax) {
            this.maxDay = newMax;
            if (this.value > this.maxDay) {
                this.set(this.maxDay);
            }
        }
    }

    public abstract class Field {
        public int value;
        String string;
        int typeCount;

        Field() {
            this.set(this.min());
        }

        abstract int max();

        abstract int length();

        int min() {
            return 0;
        }

        boolean isEditable() {
            return true;
        }

        String string() {
            return this.string;
        }

        public void set(int v) {
            this.value = v;
            this.string = String.valueOf(v);
            for (int i = this.string.length(); i < this.length(); ++i) {
                this.string = "0" + this.string;
            }
            this.fieldModified();
        }

        void fieldModified() {
            if (!BDayOfYearFE.this.isModifiedStateLocked()) {
                BDayOfYearFE.this.fieldModified(this);
            }
        }

        void increment() {
            int v = this.value + 1;
            if (v > this.max()) {
                v = this.min();
            }
            this.set(v);
        }

        void decrement() {
            int v = this.value - 1;
            if (v < this.min()) {
                v = this.max();
            }
            this.set(v);
        }

        boolean keyTyped(int key) {
            if (Character.isDigit((char)key)) {
                int v;
                int k = key - 48;
                if (this.typeCount == 0) {
                    v = k;
                } else {
                    int pow = 1;
                    for (int i = 0; i < this.length() - 1; ++i) {
                        pow *= 10;
                    }
                    v = this.value % pow * 10 + k;
                }
                if (v <= this.max()) {
                    this.set(v);
                }
                ++this.typeCount;
                return true;
            }
            return false;
        }
    }
}

