/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.fieldeditor;

import com.tridium.workbench.fieldeditors.BDynamicEnumFE;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BValueNamePickerFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BValueNamePickerFE.class);
    public static final String NULL = "{- null -}";
    private BDynamicEnumFE listbox = new BDynamicEnumFE();
    private String defType = "baja:String";
    private TypeInfo baseType = BValue.TYPE.getTypeInfo();
    private String[] loadedTypes;

    public Type getType() {
        return TYPE;
    }

    public BValueNamePickerFE() {
        this.setContent((BWidget)this.listbox);
        this.linkTo("lk1", (BComponent)this.listbox, (Slot)BDynamicEnumFE.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.listbox, (Slot)BDynamicEnumFE.pluginModified, (Slot)setModified);
    }

    protected void doSetReadonly(boolean readonly) {
        this.listbox.setEnabled(!readonly);
        this.listbox.setReadonly(readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        int i;
        if (cx != null && cx.getFacets() != null) {
            this.baseType = Sys.getRegistry().getType(cx.getFacets().gets("targetType", this.baseType.toString()));
        }
        String curValue = value.toString();
        try {
            Type type = Sys.getType((String)SlotPath.unescape((String)curValue));
            if (type.isAbstract() || type.isInterface()) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            curValue = this.defType;
        }
        int selected = 0;
        TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BValue.TYPE.getTypeInfo());
        this.loadedTypes = new String[types.length + 1];
        this.loadedTypes[0] = NULL;
        for (i = 1; i <= types.length; ++i) {
            this.loadedTypes[i] = SlotPath.escape((String)types[i].toString());
        }
        if (this.loadedTypes.length > 0) {
            SortUtil.sort((Object[])this.loadedTypes);
        }
        for (i = 0; i < this.loadedTypes.length; ++i) {
            if (!this.loadedTypes[i].equals(curValue)) continue;
            selected = i;
            break;
        }
        this.listbox.loadValue((BObject)BDynamicEnum.make((int)selected, (BEnumRange)BEnumRange.make((String[])this.loadedTypes)));
        this.repaint();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BDynamicEnum selected = (BDynamicEnum)this.listbox.saveValue();
        if (selected != null) {
            return BString.make((String)selected.getTag());
        }
        return BString.make((String)NULL);
    }
}

