/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.fieldeditor;

import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.units.BUnit;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BResizableIntegerFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BResizableIntegerFE.class);
    private BTextField field = new BTextField("", 5);
    private BLabel label = new BLabel("");
    private int radix = 10;
    private String range = "";
    private Values values;

    public Type getType() {
        return TYPE;
    }

    public BResizableIntegerFE() {
        BGridPane pane = new BGridPane(2);
        pane.add("field", (BValue)this.field);
        pane.add("units", (BValue)this.label);
        this.setContent((BWidget)pane);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.field.setEditable(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.values = value instanceof BInteger ? new IntValues() : new LongValues();
        this.radix = 10;
        this.range = "";
        String meta = "";
        BNumber min = null;
        BNumber max = null;
        if (cx != null) {
            BUnit u;
            BInteger radixFacet = (BInteger)cx.getFacet("radix");
            if (radixFacet != null) {
                this.radix = radixFacet.getInt();
            }
            if ((u = (BUnit)cx.getFacet("units")) != null && !u.isNull()) {
                meta = u.getSymbol();
            }
            min = (BNumber)cx.getFacet("min");
            max = (BNumber)cx.getFacet("max");
            BInteger width = (BInteger)cx.getFacet("fieldWidth");
            if (width != null) {
                this.field.setVisibleColumns(width.getInt());
            }
        }
        if (this.radix != 10) {
            if (meta.length() > 0) {
                meta = meta + ' ';
            }
            meta = meta + "Radix=" + this.radix;
        }
        if (this.values.loadFacets(min, max)) {
            String minStr = min == null ? "min" : this.values.toString((BObject)min, this.radix);
            String maxStr = max == null ? "max" : this.values.toString((BObject)max, this.radix);
            this.range = "[" + minStr + " - " + maxStr + "]";
            if (meta.length() > 0) {
                meta = meta + ' ';
            }
            meta = meta + this.range;
        }
        String s = this.values.toString(value, this.radix);
        this.field.setText(s);
        this.label.setText(meta);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String s = this.field.getText();
        return this.values.fromString(s, this.radix, this.range);
    }

    static class LongValues
    extends Values {
        long min = Long.MIN_VALUE;
        long max = Long.MAX_VALUE;

        LongValues() {
        }

        @Override
        boolean loadFacets(BNumber min, BNumber max) {
            if (min != null) {
                this.min = min.getLong();
            }
            if (max != null) {
                this.max = max.getLong();
            }
            return this.min != Long.MIN_VALUE || this.max != Long.MAX_VALUE;
        }

        @Override
        String toString(BObject x, int radix) {
            return this.toString(((BNumber)x).getLong(), radix);
        }

        String toString(long x, int radix) {
            if (x == Long.MIN_VALUE) {
                return "min";
            }
            if (x == Long.MAX_VALUE) {
                return "max";
            }
            return Long.toString(x, radix);
        }

        @Override
        BValue fromString(String s, int radix, String range) throws CannotSaveException {
            long x = s.equals("min") ? Long.MIN_VALUE : (s.equals("max") ? Long.MAX_VALUE : Long.parseLong(s, radix));
            if (x < this.min) {
                throw new CannotSaveException(this.toString(x, radix) + " < " + this.toString(this.min, radix) + " " + range);
            }
            if (x > this.max) {
                throw new CannotSaveException(this.toString(x, radix) + " > " + this.toString(this.max, radix) + " " + range);
            }
            return BLong.make((long)x);
        }
    }

    static class IntValues
    extends Values {
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;

        IntValues() {
        }

        @Override
        boolean loadFacets(BNumber min, BNumber max) {
            if (min != null) {
                this.min = min.getInt();
            }
            if (max != null) {
                this.max = max.getInt();
            }
            return this.min != Integer.MIN_VALUE || this.max != Integer.MAX_VALUE;
        }

        @Override
        String toString(BObject x, int radix) {
            return this.toString(((BNumber)x).getInt(), radix);
        }

        String toString(int x, int radix) {
            if (radix != 10) {
                return Long.toString((long)x & 0xFFFFFFFFL, radix);
            }
            if (x == Integer.MIN_VALUE) {
                return "min";
            }
            if (x == Integer.MAX_VALUE) {
                return "max";
            }
            return Integer.toString(x, radix);
        }

        @Override
        BValue fromString(String s, int radix, String range) throws CannotSaveException {
            int x = s.equals("min") ? Integer.MIN_VALUE : (s.equals("max") ? Integer.MAX_VALUE : (int)Long.parseLong(s, radix));
            if (x < this.min) {
                throw new CannotSaveException(this.toString(x, radix) + " < " + this.toString(this.min, radix) + " " + range);
            }
            if (x > this.max) {
                throw new CannotSaveException(this.toString(x, radix) + " > " + this.toString(this.max, radix) + " " + range);
            }
            return BInteger.make((int)x);
        }
    }

    static abstract class Values {
        Values() {
        }

        abstract boolean loadFacets(BNumber var1, BNumber var2);

        abstract String toString(BObject var1, int var2);

        abstract BValue fromString(String var1, int var2, String var3) throws CannotSaveException;
    }
}

