/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.fieldeditor;

import com.tridium.sys.Nre;
import java.text.DecimalFormat;
import javax.baja.gx.BBrush;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BResizableFloatFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BResizableFloatFE.class);
    private static IntHashMap formatters = new IntHashMap();
    private BTextField field = new BTextField("", 5);
    protected BLabel label = new BLabel("");
    private String range = "";
    private DecimalFormat format = BResizableFloatFE.getFormat(2);
    private boolean isFloat = true;
    private BUnit realUnits;
    private BUnit displayUnits;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private double MIN = Double.NEGATIVE_INFINITY;
    private double MAX = Double.POSITIVE_INFINITY;
    BBrush fg = BBrush.NULL;
    BBrush bg = BBrush.NULL;

    public Type getType() {
        return TYPE;
    }

    public BResizableFloatFE() {
        this.field.setRenderer((TextRenderer)new Renderer());
        BGridPane pane = new BGridPane(2);
        pane.add("field", (BValue)this.field);
        pane.add("units", (BValue)this.label);
        this.setContent((BWidget)pane);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.field.setEditable(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.isFloat = value instanceof BFloat;
        if (this.isFloat) {
            this.MIN = Double.NEGATIVE_INFINITY;
            this.MAX = Double.POSITIVE_INFINITY;
        } else {
            this.MIN = Double.NEGATIVE_INFINITY;
            this.MAX = Double.POSITIVE_INFINITY;
        }
        this.min = this.MIN;
        this.max = this.MAX;
        double v = ((BNumber)value).getDouble();
        this.format = BResizableFloatFE.getFormat(2);
        this.realUnits = null;
        int convert = Nre.unitConversion;
        if (cx != null) {
            BNumber maxFacet;
            BNumber minFacet;
            BNumber prec;
            this.realUnits = (BUnit)cx.getFacet("units");
            if (this.realUnits != null && this.realUnits.isNull()) {
                this.realUnits = null;
            }
            if ((prec = (BNumber)cx.getFacet("precision")) != null) {
                this.format = BResizableFloatFE.getFormat(prec.getInt());
            }
            if ((minFacet = (BNumber)cx.getFacet("min")) != null) {
                double d = this.min = this.isFloat ? (double)minFacet.getFloat() : minFacet.getDouble();
            }
            if ((maxFacet = (BNumber)cx.getFacet("max")) != null) {
                this.max = this.isFloat ? (double)maxFacet.getFloat() : maxFacet.getDouble();
            }
            convert = cx.getFacets().geti("unitConversion", convert);
            BInteger width = (BInteger)cx.getFacet("fieldWidth");
            if (width != null) {
                this.field.setVisibleColumns(width.getInt());
            }
        }
        this.displayUnits = this.realUnits;
        if (convert != 0 && this.realUnits != null) {
            BUnitConversion c = BUnitConversion.make((int)convert);
            this.displayUnits = c.getDesiredUnit(this.realUnits);
            if (this.displayUnits != this.realUnits) {
                v = this.realUnits.convertTo(this.displayUnits, v);
                this.min = this.realUnits.convertTo(this.displayUnits, this.min);
                this.max = this.realUnits.convertTo(this.displayUnits, this.max);
            }
        }
        String meta = "";
        if (this.displayUnits != null) {
            meta = this.displayUnits.getSymbol();
        }
        if (this.min != this.MIN || this.max != this.MAX) {
            this.range = '[' + this.toString(this.min) + " - " + this.toString(this.max) + ']';
            if (meta.length() > 0) {
                meta = meta + ' ';
            }
            meta = meta + this.range;
        }
        this.field.setText(this.toString(v));
        this.label.setText(meta);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String text = this.field.getText();
        double v = 0.0;
        try {
            text = TextUtil.toLowerCase((String)text);
            v = text.equals("-inf") ? Double.NEGATIVE_INFINITY : (text.equals("+inf") ? Double.POSITIVE_INFINITY : (text.equals("nan") ? Double.NaN : this.format.parse(text).doubleValue()));
        }
        catch (RuntimeException e) {
            throw new CannotSaveException("Invalid format: " + text);
        }
        if (v < this.min) {
            throw new CannotSaveException(this.toString(v) + " < " + this.toString(this.min) + " " + this.range);
        }
        if (v > this.max) {
            throw new CannotSaveException(this.toString(v) + " > " + this.toString(this.max) + " " + this.range);
        }
        if (this.realUnits != this.displayUnits) {
            v = this.displayUnits.convertTo(this.realUnits, v);
        }
        if (this.isFloat) {
            return BFloat.make((float)((float)v));
        }
        return BDouble.make((double)v);
    }

    private String toString(double d) {
        if (d == this.MIN) {
            return "-inf";
        }
        if (d == this.MAX) {
            return "+inf";
        }
        if (this.isFloat && Float.isNaN((float)d)) {
            return "nan";
        }
        if (!this.isFloat && Double.isNaN(d)) {
            return "nan";
        }
        return this.format.format(d);
    }

    public void requestFocus() {
        this.field.requestFocus();
    }

    private static DecimalFormat getFormat(int precision) {
        DecimalFormat formatter = (DecimalFormat)formatters.get(precision);
        if (formatter == null) {
            StringBuffer pattern = new StringBuffer(16);
            pattern.append("#0");
            if (precision > 0) {
                pattern.append('.');
                for (int i = 0; i < precision; ++i) {
                    pattern.append('0');
                }
            }
            formatter = new DecimalFormat(pattern.toString());
            formatters.put(precision, (Object)formatter);
        }
        return formatter;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 306: {
                this.fg = (BBrush)a;
                this.bg = (BBrush)b;
                this.repaint();
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    class Renderer
    extends TextRenderer {
        Renderer() {
        }

        public BBrush getBackground() {
            if (BResizableFloatFE.this.bg.isNull()) {
                return super.getBackground();
            }
            return BResizableFloatFE.this.bg;
        }

        public BBrush getForeground(Segment seg) {
            if (BResizableFloatFE.this.fg.isNull()) {
                return super.getForeground(seg);
            }
            return BResizableFloatFE.this.fg;
        }
    }
}

