/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.fieldeditor;

import com.lynxspring.control.BAstroClock;
import com.lynxspring.control.util.Util;
import com.tridium.workbench.fieldeditors.BTimeZoneFE;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BAstroTimeZoneFE
extends BWbFieldEditor {
    public static final Action update = BAstroTimeZoneFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BAstroTimeZoneFE.class);
    private BTimeZone localTimeZone;
    private BCheckBox useLocal;
    private BListDropDown timeZones;

    public void update() {
        this.invoke(update, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAstroTimeZoneFE() {
        BGridPane grid = new BGridPane(2);
        grid.setColumnGap(6.0);
        this.useLocal = new BCheckBox("Use Station Time Zone");
        grid.add(null, (BValue)this.useLocal);
        this.timeZones = new BListDropDown();
        grid.add(null, (BValue)this.timeZones);
        this.setContent((BWidget)grid);
        this.linkTo((BComponent)this.useLocal, (Slot)BCheckBox.actionPerformed, (Slot)update);
        this.linkTo((BComponent)this.timeZones, (Slot)BListDropDown.valueModified, (Slot)setModified);
    }

    public void doLoadValue(BObject value, Context cx) {
        if (!(value instanceof BTimeZone)) {
            return;
        }
        BTimeZone zone = (BTimeZone)value;
        BAstroClock clock = null;
        BWidget parent = this.getParentWidget();
        while (clock == null && parent != null && !parent.isNull()) {
            if (parent instanceof BWbEditor && ((BWbEditor)parent).getCurrentValue() instanceof BAstroClock) {
                clock = (BAstroClock)((BWbEditor)parent).getCurrentValue();
                continue;
            }
            parent = parent.getParentWidget();
        }
        if (clock == null) {
            Util.log.error("Could not find clock");
            BTimeZoneFE editor = new BTimeZoneFE();
            editor.loadValue((BObject)zone);
            this.setContent((BWidget)editor);
            return;
        }
        this.localTimeZone = clock.getLocalTimeZone();
        this.useLocal.setSelected(zone.equals((Object)this.localTimeZone));
        this.timeZones.getList().setModel((ListModel)new ZoneListModel(clock.getLocalTimeZones()));
        this.timeZones.setSelectedItem((Object)zone);
        this.doUpdate(false);
    }

    public void doUpdate() {
        this.doUpdate(true);
    }

    public void doUpdate(boolean modified) {
        this.timeZones.setEnabled(!this.useLocal.isSelected());
        if (modified) {
            this.setModified();
        }
    }

    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (this.useLocal.isSelected()) {
            return this.localTimeZone.newCopy(true);
        }
        return ((BTimeZone)this.timeZones.getSelectedItem()).newCopy(true);
    }

    private static class ZoneListModel
    extends ListModel {
        BTimeZone[] items;

        public ZoneListModel(BVector zones) {
            this.items = (BTimeZone[])zones.getChildren(BTimeZone.class);
        }

        public int getItemCount() {
            return this.items.length;
        }

        public BTimeZone getTimeZone(int i) {
            return this.items[i];
        }

        public Object getItem(int i) {
            return this.getTimeZone(i);
        }
    }
}

