/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.fieldeditor;

import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public abstract class BAstroFieldEditor
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BAstroFieldEditor.class);
    private static final BFacets degFacets = BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0));
    private BWbFieldEditor dir;
    private BWbFieldEditor deg;
    private BWbFieldEditor min;

    public Type getType() {
        return TYPE;
    }

    public BAstroFieldEditor() {
        BGridPane grid = new BGridPane(7);
        this.dir = BWbFieldEditor.makeFor((BObject)BBoolean.FALSE, (Context)this.dirFacets());
        grid.add(null, (BValue)this.dir);
        grid.add(null, (BValue)new BNullWidget());
        this.deg = BWbFieldEditor.makeFor((BObject)BDouble.DEFAULT, (Context)degFacets);
        grid.add(null, (BValue)this.deg);
        grid.add(null, (BValue)new BLabel("deg"));
        grid.add(null, (BValue)new BLabel(" - "));
        this.min = BWbFieldEditor.makeFor((BObject)BDouble.DEFAULT);
        grid.add(null, (BValue)this.min);
        grid.add(null, (BValue)new BLabel("min"));
        this.setContent((BWidget)grid);
        this.linkTo((BComponent)this.dir, (Slot)BWbPlugin.setModified, (Slot)setModified);
        this.linkTo((BComponent)this.deg, (Slot)BWbPlugin.setModified, (Slot)setModified);
        this.linkTo((BComponent)this.min, (Slot)BWbPlugin.setModified, (Slot)setModified);
    }

    public void doLoadValue(BObject value, Context cx) {
        if (!(value instanceof BDouble)) {
            return;
        }
        double dValue = ((BDouble)value).getDouble();
        this.dir.loadValue((BObject)BBoolean.make((dValue >= 0.0 ? 1 : 0) != 0), (Context)this.dirFacets());
        if (dValue < 0.0) {
            dValue = 0.0 - dValue;
        }
        double degs = Math.floor(dValue);
        double mins = 60.0 * (dValue - degs);
        this.deg.loadValue((BObject)BDouble.make((double)degs), (Context)degFacets);
        this.min.loadValue((BObject)BDouble.make((double)mins));
    }

    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        double dValue = ((BDouble)this.deg.saveValue()).getDouble();
        double mins = ((BDouble)this.min.saveValue()).getDouble();
        if (mins != 0.0 && dValue == Math.floor(dValue)) {
            dValue += mins / 60.0;
        }
        if (dValue > this.getLimit()) {
            dValue = this.getLimit();
        }
        if (!((BBoolean)this.dir.saveValue()).getBoolean()) {
            dValue = 0.0 - dValue;
        }
        return BDouble.make((double)dValue);
    }

    public abstract BFacets dirFacets();

    public abstract double getLimit();
}

