/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaCore.units;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpcUaUnitConverter {
    private static final String VOCABULARY_FILE = "/rc/QUDTUnitVocabV21.txt";
    private static final String OPCUA_UNITS_FILE = "/rc/UNECE_to_OPCUA.csv";
    private static final Map<String, String> uneceToOpcUaUnitIdMap = new HashMap<String, String>();
    private static final Map<String, String> unitNameToUnitIdMap = new HashMap<String, String>();
    private static final Map<String, String> unitIdToUnitNameMap = new HashMap<String, String>();
    private static final Map<String, String> qudtCodeToOpcUaUnitIdMap = new HashMap<String, String>();
    private static final Map<String, String> unitIdToOpcUaDisplayNameMap = new HashMap<String, String>();
    private static OpcUaUnitConverter converter = null;
    private static final Logger logger = Logger.getLogger("opcUaCore.UnitUtil");

    private static void initConverter() {
        converter = new OpcUaUnitConverter();
        converter.loadOpcUaUnitsCsv();
        converter.loadQudtUnitVocab();
    }

    public static OpcUaUnitConverter getDefault() {
        if (converter == null) {
            OpcUaUnitConverter.initConverter();
        }
        return converter;
    }

    private void loadOpcUaUnitsCsv() {
        StringBuilder content = this.readFileContent(OPCUA_UNITS_FILE);
        if (content == null) {
            logger.severe("Error: Unable to read OPC UA units CSV file.");
            return;
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(content.toString()));){
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] columns = line.split(",");
                if (columns.length < 2) continue;
                String uneceCode = columns[0].trim().toLowerCase();
                String unitId = columns[1].trim().toLowerCase();
                String unitDisplayName = columns[2].trim().toLowerCase().replace("\"", "");
                if (uneceCode.isEmpty() || unitId.isEmpty()) continue;
                uneceToOpcUaUnitIdMap.put(uneceCode, unitId);
                unitIdToOpcUaDisplayNameMap.put(unitId, unitDisplayName);
            }
        }
        catch (IOException e2) {
            logger.severe("Error parsing OPC UA units CSV: " + e2);
        }
    }

    private void loadQudtUnitVocab() {
        StringBuilder content = this.readFileContent(VOCABULARY_FILE);
        if (content == null) {
            logger.severe("Error: Unable to read QUDT vocabulary file.");
            return;
        }
        String[] unitBlocks = content.toString().split("\\.\\s*\\n");
        Pattern unitNamePattern = Pattern.compile("rdfs:label\\s+\"(.+?)\"@en\\s*;");
        Pattern unitNameUSPattern = Pattern.compile("rdfs:label\\s+\"(.+?)\"@en-us\\s*;");
        Pattern uneceCodePattern = Pattern.compile("qudt:uneceCommonCode\\s+\"?(\\S+?)\"?\\s*;");
        Pattern qudtCodePattern = Pattern.compile("^unit:(\\S+)");
        for (String block : unitBlocks) {
            String opcUaUnitId;
            Matcher unitNameMatcher;
            String currentQudtCode = null;
            String currentUnitName = null;
            String currentUneceCode = null;
            Matcher qudtCodeMatcher = qudtCodePattern.matcher(block);
            if (qudtCodeMatcher.find()) {
                currentQudtCode = qudtCodeMatcher.group(1).trim().toLowerCase();
            }
            if ((unitNameMatcher = unitNameUSPattern.matcher(block)).find()) {
                currentUnitName = unitNameMatcher.group(1).trim().toLowerCase();
            } else {
                unitNameMatcher = unitNamePattern.matcher(block);
                if (unitNameMatcher.find()) {
                    currentUnitName = unitNameMatcher.group(1).trim().toLowerCase();
                }
            }
            Matcher uneceCodeMatcher = uneceCodePattern.matcher(block);
            if (uneceCodeMatcher.find()) {
                currentUneceCode = uneceCodeMatcher.group(1).trim().replace("\"", "").toLowerCase();
            }
            if (currentQudtCode == null || currentUneceCode == null || (opcUaUnitId = uneceToOpcUaUnitIdMap.get(currentUneceCode)) == null) continue;
            qudtCodeToOpcUaUnitIdMap.put(currentQudtCode, opcUaUnitId);
            unitIdToUnitNameMap.put(opcUaUnitId, currentUnitName);
        }
    }

    /*
     * Exception decompiling
     */
    private StringBuilder readFileContent(String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getOpcUaUnitIdFromQudtCode(String qudtCode) {
        if (converter == null) {
            OpcUaUnitConverter.initConverter();
        }
        if (qudtCode == null) {
            return -1;
        }
        String opcUaUnitId = qudtCodeToOpcUaUnitIdMap.get(qudtCode.toLowerCase());
        if (opcUaUnitId == null) {
            logger.warning("OPC UA Unit ID not found for QUDT code: " + qudtCode);
            return -1;
        }
        return Integer.parseInt(opcUaUnitId);
    }

    public String getUnitNameFromOpcuaUnitId(int opcUaUnitId) {
        String unitIdStr;
        String unitName;
        if (converter == null) {
            OpcUaUnitConverter.initConverter();
        }
        if ((unitName = unitIdToUnitNameMap.get(unitIdStr = String.valueOf(opcUaUnitId))) == null) {
            logger.warning("Unit name not found for OPC UA Unit ID: " + opcUaUnitId);
        }
        return unitName;
    }

    public String getUnitDescriptionFromQudtCode(String qudtCode) {
        if (converter == null) {
            OpcUaUnitConverter.initConverter();
        }
        if (qudtCode == null) {
            return null;
        }
        String unecCode = qudtCodeToOpcUaUnitIdMap.get(qudtCode.toLowerCase());
        String description = unitIdToOpcUaDisplayNameMap.get(unecCode);
        if (description == null) {
            logger.warning("OPC UA Unit Description not found for QUDT code: " + qudtCode);
        }
        return description;
    }

    public void dumpMappings() {
        if (converter == null) {
            OpcUaUnitConverter.initConverter();
        }
        logger.info("%-40s | %-15s%n\tUnit Name\tOPC UA Unit ID");
        logger.info("----------------------------------------+-----------------");
        for (Map.Entry<String, String> entry : unitNameToUnitIdMap.entrySet()) {
            String unitName = entry.getKey();
            String unitId = entry.getValue();
            logger.info("%-40s | %-15s%n\t" + unitName + "\t" + unitId);
        }
    }
}

