/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.AxisInformation;
import com.prosysopc.ua.types.opcua.XYArrayItemType;
import com.prosysopc.ua.types.opcua.server.ArrayItemTypeNode;
import com.prosysopc.ua.types.opcua.server.XYArrayItemTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12038")
public abstract class XYArrayItemTypeNodeBase
extends ArrayItemTypeNode
implements XYArrayItemType {
    private static GeneratedNodeInitializer<XYArrayItemTypeNode> PZ;

    protected XYArrayItemTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<XYArrayItemTypeNode> generatedNodeInitializer = XYArrayItemTypeNodeBase.getXYArrayItemTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((XYArrayItemTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<XYArrayItemTypeNode> getXYArrayItemTypeNodeInitializer() {
        return PZ;
    }

    public static void setXYArrayItemTypeNodeInitializer(GeneratedNodeInitializer<XYArrayItemTypeNode> generatedNodeInitializer) {
        PZ = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getXAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "XAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getXAxisDefinition() {
        UaProperty uaProperty = this.getXAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node XAxisDefinition does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setXAxisDefinition(AxisInformation axisInformation) {
        UaProperty uaProperty = this.getXAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting XAxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting XAxisDefinition failed unexpectedly", statusException);
        }
    }
}

