/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.TwoStateDiscreteType;
import com.prosysopc.ua.types.opcua.server.DiscreteItemTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateDiscreteTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2373")
public abstract class TwoStateDiscreteTypeNodeBase
extends DiscreteItemTypeNode
implements TwoStateDiscreteType {
    private static GeneratedNodeInitializer<TwoStateDiscreteTypeNode> PE;

    protected TwoStateDiscreteTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<TwoStateDiscreteTypeNode> generatedNodeInitializer = TwoStateDiscreteTypeNodeBase.getTwoStateDiscreteTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((TwoStateDiscreteTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<TwoStateDiscreteTypeNode> getTwoStateDiscreteTypeNodeInitializer() {
        return PE;
    }

    public static void setTwoStateDiscreteTypeNodeInitializer(GeneratedNodeInitializer<TwoStateDiscreteTypeNode> generatedNodeInitializer) {
        PE = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getTrueStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrueState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTrueState() {
        UaProperty uaProperty = this.getTrueStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node TrueState does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTrueState(LocalizedText localizedText) {
        UaProperty uaProperty = this.getTrueStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TrueState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TrueState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getFalseStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FalseState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getFalseState() {
        UaProperty uaProperty = this.getFalseStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node FalseState does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setFalseState(LocalizedText localizedText) {
        UaProperty uaProperty = this.getFalseStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting FalseState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting FalseState failed unexpectedly", statusException);
        }
    }
}

