/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.TrustListUpdatedAuditEventType;
import com.prosysopc.ua.types.opcua.server.AuditEventTypeNode;
import com.prosysopc.ua.types.opcua.server.TrustListUpdatedAuditEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12561")
public abstract class TrustListUpdatedAuditEventTypeNodeBase
extends AuditEventTypeNode
implements TrustListUpdatedAuditEventType {
    private static GeneratedNodeInitializer<TrustListUpdatedAuditEventTypeNode> PD;

    protected TrustListUpdatedAuditEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<TrustListUpdatedAuditEventTypeNode> generatedNodeInitializer = TrustListUpdatedAuditEventTypeNodeBase.getTrustListUpdatedAuditEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((TrustListUpdatedAuditEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<TrustListUpdatedAuditEventTypeNode> getTrustListUpdatedAuditEventTypeNodeInitializer() {
        return PD;
    }

    public static void setTrustListUpdatedAuditEventTypeNodeInitializer(GeneratedNodeInitializer<TrustListUpdatedAuditEventTypeNode> generatedNodeInitializer) {
        PD = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getTrustListIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrustListId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getTrustListId() {
        UaProperty uaProperty = this.getTrustListIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node TrustListId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setTrustListId(NodeId nodeId) {
        UaProperty uaProperty = this.getTrustListIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TrustListId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TrustListId failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

