/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.RedundantServerDataType;
import com.prosysopc.ua.types.opcua.TransparentRedundancyType;
import com.prosysopc.ua.types.opcua.server.ServerRedundancyTypeNode;
import com.prosysopc.ua.types.opcua.server.TransparentRedundancyTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2036")
public abstract class TransparentRedundancyTypeNodeBase
extends ServerRedundancyTypeNode
implements TransparentRedundancyType {
    private static GeneratedNodeInitializer<TransparentRedundancyTypeNode> Pu;

    protected TransparentRedundancyTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<TransparentRedundancyTypeNode> generatedNodeInitializer = TransparentRedundancyTypeNodeBase.getTransparentRedundancyTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((TransparentRedundancyTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<TransparentRedundancyTypeNode> getTransparentRedundancyTypeNodeInitializer() {
        return Pu;
    }

    public static void setTransparentRedundancyTypeNodeInitializer(GeneratedNodeInitializer<TransparentRedundancyTypeNode> generatedNodeInitializer) {
        Pu = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getRedundantServerArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RedundantServerArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public RedundantServerDataType[] getRedundantServerArray() {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node RedundantServerArray does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (RedundantServerDataType[])object;
    }

    @Override
    @Mandatory
    public void setRedundantServerArray(RedundantServerDataType[] redundantServerDataTypeArray) {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RedundantServerArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(redundantServerDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RedundantServerArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getCurrentServerIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentServerId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getCurrentServerId() {
        UaProperty uaProperty = this.getCurrentServerIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node CurrentServerId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setCurrentServerId(String string) {
        UaProperty uaProperty = this.getCurrentServerIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CurrentServerId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentServerId failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

