/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.StateMachineType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.StateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.StateVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.TransitionVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2299")
public abstract class StateMachineTypeNodeBase
extends BaseObjectTypeNode
implements StateMachineType {
    private static GeneratedNodeInitializer<StateMachineTypeNode> OK;

    protected StateMachineTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getLastTransitionNode());
        this.callAfterCreateIfExists(this.getCurrentStateNode());
        GeneratedNodeInitializer<StateMachineTypeNode> generatedNodeInitializer = StateMachineTypeNodeBase.getStateMachineTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((StateMachineTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<StateMachineTypeNode> getStateMachineTypeNodeInitializer() {
        return OK;
    }

    public static void setStateMachineTypeNodeInitializer(GeneratedNodeInitializer<StateMachineTypeNode> generatedNodeInitializer) {
        OK = generatedNodeInitializer;
    }

    @Override
    @Optional
    public TransitionVariableTypeNode getLastTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastTransition");
        return (TransitionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLastTransition() {
        TransitionVariableTypeNode transitionVariableTypeNode = this.getLastTransitionNode();
        if (transitionVariableTypeNode == null) {
            return null;
        }
        Object object = transitionVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLastTransition(LocalizedText localizedText) {
        TransitionVariableTypeNode transitionVariableTypeNode = this.getLastTransitionNode();
        if (transitionVariableTypeNode == null) {
            throw new RuntimeException("Setting LastTransition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            transitionVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastTransition failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public StateVariableTypeNode getCurrentStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentState");
        return (StateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getCurrentState() {
        StateVariableTypeNode stateVariableTypeNode = this.getCurrentStateNode();
        if (stateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentState does not exist");
        }
        Object object = stateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText localizedText) {
        StateVariableTypeNode stateVariableTypeNode = this.getCurrentStateNode();
        if (stateVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            stateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentState failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

