/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.SemanticChangeStructureDataType;
import com.prosysopc.ua.types.opcua.SemanticChangeEventType;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;
import com.prosysopc.ua.types.opcua.server.SemanticChangeEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2738")
public abstract class SemanticChangeEventTypeNodeBase
extends BaseEventTypeNode
implements SemanticChangeEventType {
    private static GeneratedNodeInitializer<SemanticChangeEventTypeNode> NU;

    protected SemanticChangeEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<SemanticChangeEventTypeNode> generatedNodeInitializer = SemanticChangeEventTypeNodeBase.getSemanticChangeEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((SemanticChangeEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<SemanticChangeEventTypeNode> getSemanticChangeEventTypeNodeInitializer() {
        return NU;
    }

    public static void setSemanticChangeEventTypeNodeInitializer(GeneratedNodeInitializer<SemanticChangeEventTypeNode> generatedNodeInitializer) {
        NU = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getChangesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Changes");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public SemanticChangeStructureDataType[] getChanges() {
        UaProperty uaProperty = this.getChangesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Changes does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (SemanticChangeStructureDataType[])object;
    }

    @Override
    @Mandatory
    public void setChanges(SemanticChangeStructureDataType[] semanticChangeStructureDataTypeArray) {
        UaProperty uaProperty = this.getChangesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Changes failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(semanticChangeStructureDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Changes failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

