/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.OffNormalAlarmType;
import com.prosysopc.ua.types.opcua.server.DiscreteAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.OffNormalAlarmTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=10637")
public abstract class OffNormalAlarmTypeNodeBase
extends DiscreteAlarmTypeNode
implements OffNormalAlarmType {
    private static GeneratedNodeInitializer<OffNormalAlarmTypeNode> LS;

    protected OffNormalAlarmTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<OffNormalAlarmTypeNode> generatedNodeInitializer = OffNormalAlarmTypeNodeBase.getOffNormalAlarmTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((OffNormalAlarmTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<OffNormalAlarmTypeNode> getOffNormalAlarmTypeNodeInitializer() {
        return LS;
    }

    public static void setOffNormalAlarmTypeNodeInitializer(GeneratedNodeInitializer<OffNormalAlarmTypeNode> generatedNodeInitializer) {
        LS = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getNormalStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NormalState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getNormalState() {
        UaProperty uaProperty = this.getNormalStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node NormalState does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setNormalState(NodeId nodeId) {
        UaProperty uaProperty = this.getNormalStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NormalState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NormalState failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

