/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.TsnStreamState;
import com.prosysopc.ua.types.opcua.IIeeeBaseTsnStreamType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseInterfaceTypeNode;
import com.prosysopc.ua.types.opcua.server.IIeeeBaseTsnStreamTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24173")
public abstract class IIeeeBaseTsnStreamTypeNodeBase
extends BaseInterfaceTypeNode
implements IIeeeBaseTsnStreamType {
    private static GeneratedNodeInitializer<IIeeeBaseTsnStreamTypeNode> KU;

    protected IIeeeBaseTsnStreamTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getStreamIdNode());
        this.callAfterCreateIfExists(this.getStateNode());
        this.callAfterCreateIfExists(this.getAccumulatedLatencyNode());
        this.callAfterCreateIfExists(this.getSrClassIdNode());
        this.callAfterCreateIfExists(this.getStreamNameNode());
        GeneratedNodeInitializer<IIeeeBaseTsnStreamTypeNode> generatedNodeInitializer = IIeeeBaseTsnStreamTypeNodeBase.getIIeeeBaseTsnStreamTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((IIeeeBaseTsnStreamTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<IIeeeBaseTsnStreamTypeNode> getIIeeeBaseTsnStreamTypeNodeInitializer() {
        return KU;
    }

    public static void setIIeeeBaseTsnStreamTypeNodeInitializer(GeneratedNodeInitializer<IIeeeBaseTsnStreamTypeNode> generatedNodeInitializer) {
        KU = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getStreamIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StreamId");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte[] getStreamId() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStreamIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node StreamId does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedByte[])object;
    }

    @Override
    @Mandatory
    public void setStreamId(UnsignedByte[] unsignedByteArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStreamIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting StreamId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedByteArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StreamId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "State");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public TsnStreamState getState() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node State does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (TsnStreamState)variant.asEnum(TsnStreamState.class);
    }

    @Override
    @Mandatory
    public void setState(TsnStreamState tsnStreamState) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting State failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(tsnStreamState);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting State failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getAccumulatedLatencyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AccumulatedLatency");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getAccumulatedLatency() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAccumulatedLatencyNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setAccumulatedLatency(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAccumulatedLatencyNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting AccumulatedLatency failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AccumulatedLatency failed unexpectedly", statusException);
        }
    }

    public void setAccumulatedLatency(long l2) {
        this.setAccumulatedLatency(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getSrClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SrClassId");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedByte getSrClassId() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSrClassIdNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Optional
    public void setSrClassId(UnsignedByte unsignedByte) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSrClassIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SrClassId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedByte);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SrClassId failed unexpectedly", statusException);
        }
    }

    public void setSrClassId(int n2) {
        this.setSrClassId(UnsignedByte.valueOf(n2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getStreamNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StreamName");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getStreamName() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStreamNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node StreamName does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setStreamName(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStreamNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting StreamName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StreamName failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

