/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.NegotiationStatus;
import com.prosysopc.ua.types.opcua.IIeeeAutoNegotiationStatusType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseInterfaceTypeNode;
import com.prosysopc.ua.types.opcua.server.IIeeeAutoNegotiationStatusTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24233")
public abstract class IIeeeAutoNegotiationStatusTypeNodeBase
extends BaseInterfaceTypeNode
implements IIeeeAutoNegotiationStatusType {
    private static GeneratedNodeInitializer<IIeeeAutoNegotiationStatusTypeNode> KR;

    protected IIeeeAutoNegotiationStatusTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getNegotiationStatusNode());
        GeneratedNodeInitializer<IIeeeAutoNegotiationStatusTypeNode> generatedNodeInitializer = IIeeeAutoNegotiationStatusTypeNodeBase.getIIeeeAutoNegotiationStatusTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((IIeeeAutoNegotiationStatusTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<IIeeeAutoNegotiationStatusTypeNode> getIIeeeAutoNegotiationStatusTypeNodeInitializer() {
        return KR;
    }

    public static void setIIeeeAutoNegotiationStatusTypeNodeInitializer(GeneratedNodeInitializer<IIeeeAutoNegotiationStatusTypeNode> generatedNodeInitializer) {
        KR = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getNegotiationStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NegotiationStatus");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public NegotiationStatus getNegotiationStatus() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getNegotiationStatusNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node NegotiationStatus does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (NegotiationStatus)variant.asEnum(NegotiationStatus.class);
    }

    @Override
    @Mandatory
    public void setNegotiationStatus(NegotiationStatus negotiationStatus) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getNegotiationStatusNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting NegotiationStatus failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(negotiationStatus);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NegotiationStatus failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

