/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.CartesianCoordinates;
import com.prosysopc.ua.stack.core.Orientation;
import com.prosysopc.ua.types.opcua.FrameType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.CartesianCoordinatesTypeNode;
import com.prosysopc.ua.types.opcua.server.FrameTypeNode;
import com.prosysopc.ua.types.opcua.server.OrientationTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18786")
public abstract class FrameTypeNodeBase
extends BaseDataVariableTypeNode
implements FrameType {
    private static GeneratedNodeInitializer<FrameTypeNode> KH;

    protected FrameTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getBaseFrameNode());
        this.callAfterCreateIfExists(this.getCartesianCoordinatesNode());
        this.callAfterCreateIfExists(this.getOrientationNode());
        GeneratedNodeInitializer<FrameTypeNode> generatedNodeInitializer = FrameTypeNodeBase.getFrameTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((FrameTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<FrameTypeNode> getFrameTypeNodeInitializer() {
        return KH;
    }

    public static void setFrameTypeNodeInitializer(GeneratedNodeInitializer<FrameTypeNode> generatedNodeInitializer) {
        KH = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getConstantNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Constant");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isConstant() {
        UaProperty uaProperty = this.getConstantNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setConstant(Boolean bl) {
        UaProperty uaProperty = this.getConstantNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Constant failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Constant failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getFixedBaseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FixedBase");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isFixedBase() {
        UaProperty uaProperty = this.getFixedBaseNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setFixedBase(Boolean bl) {
        UaProperty uaProperty = this.getFixedBaseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting FixedBase failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting FixedBase failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getBaseFrameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BaseFrame");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public NodeId getBaseFrame() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBaseFrameNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Optional
    public void setBaseFrame(NodeId nodeId) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBaseFrameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting BaseFrame failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BaseFrame failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public CartesianCoordinatesTypeNode getCartesianCoordinatesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CartesianCoordinates");
        return (CartesianCoordinatesTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public CartesianCoordinates getCartesianCoordinates() {
        CartesianCoordinatesTypeNode cartesianCoordinatesTypeNode = this.getCartesianCoordinatesNode();
        if (cartesianCoordinatesTypeNode == null) {
            throw new RuntimeException("Mandatory node CartesianCoordinates does not exist");
        }
        Object object = cartesianCoordinatesTypeNode.getValue().getValue().getValue();
        return (CartesianCoordinates)object;
    }

    @Override
    @Mandatory
    public void setCartesianCoordinates(CartesianCoordinates cartesianCoordinates) {
        CartesianCoordinatesTypeNode cartesianCoordinatesTypeNode = this.getCartesianCoordinatesNode();
        if (cartesianCoordinatesTypeNode == null) {
            throw new RuntimeException("Setting CartesianCoordinates failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            cartesianCoordinatesTypeNode.setValue(cartesianCoordinates);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CartesianCoordinates failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public OrientationTypeNode getOrientationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Orientation");
        return (OrientationTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Orientation getOrientation() {
        OrientationTypeNode orientationTypeNode = this.getOrientationNode();
        if (orientationTypeNode == null) {
            throw new RuntimeException("Mandatory node Orientation does not exist");
        }
        Object object = orientationTypeNode.getValue().getValue().getValue();
        return (Orientation)object;
    }

    @Override
    @Mandatory
    public void setOrientation(Orientation orientation) {
        OrientationTypeNode orientationTypeNode = this.getOrientationNode();
        if (orientationTypeNode == null) {
            throw new RuntimeException("Setting Orientation failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            orientationTypeNode.setValue(orientation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Orientation failed unexpectedly", statusException);
        }
    }
}

