/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.FiniteStateMachineType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteStateVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteTransitionVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.StateMachineTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2771")
public abstract class FiniteStateMachineTypeNodeBase
extends StateMachineTypeNode
implements FiniteStateMachineType {
    private static GeneratedNodeInitializer<FiniteStateMachineTypeNode> KC;

    protected FiniteStateMachineTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getAvailableStatesNode());
        this.callAfterCreateIfExists(this.getLastTransitionNode());
        this.callAfterCreateIfExists(this.getAvailableTransitionsNode());
        this.callAfterCreateIfExists(this.getCurrentStateNode());
        GeneratedNodeInitializer<FiniteStateMachineTypeNode> generatedNodeInitializer = FiniteStateMachineTypeNodeBase.getFiniteStateMachineTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((FiniteStateMachineTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<FiniteStateMachineTypeNode> getFiniteStateMachineTypeNodeInitializer() {
        return KC;
    }

    public static void setFiniteStateMachineTypeNodeInitializer(GeneratedNodeInitializer<FiniteStateMachineTypeNode> generatedNodeInitializer) {
        KC = generatedNodeInitializer;
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getAvailableStatesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AvailableStates");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public NodeId[] getAvailableStates() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAvailableStatesNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Optional
    public void setAvailableStates(NodeId[] nodeIdArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAvailableStatesNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting AvailableStates failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(nodeIdArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AvailableStates failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public FiniteTransitionVariableTypeNode getLastTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastTransition");
        return (FiniteTransitionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLastTransition() {
        FiniteTransitionVariableTypeNode finiteTransitionVariableTypeNode = this.getLastTransitionNode();
        if (finiteTransitionVariableTypeNode == null) {
            return null;
        }
        Object object = finiteTransitionVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLastTransition(LocalizedText localizedText) {
        FiniteTransitionVariableTypeNode finiteTransitionVariableTypeNode = this.getLastTransitionNode();
        if (finiteTransitionVariableTypeNode == null) {
            throw new RuntimeException("Setting LastTransition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            finiteTransitionVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastTransition failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getAvailableTransitionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AvailableTransitions");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public NodeId[] getAvailableTransitions() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAvailableTransitionsNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Optional
    public void setAvailableTransitions(NodeId[] nodeIdArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAvailableTransitionsNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting AvailableTransitions failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(nodeIdArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AvailableTransitions failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public FiniteStateVariableTypeNode getCurrentStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentState");
        return (FiniteStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getCurrentState() {
        FiniteStateVariableTypeNode finiteStateVariableTypeNode = this.getCurrentStateNode();
        if (finiteStateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentState does not exist");
        }
        Object object = finiteStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText localizedText) {
        FiniteStateVariableTypeNode finiteStateVariableTypeNode = this.getCurrentStateNode();
        if (finiteStateVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            finiteStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentState failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

