/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.DiscrepancyAlarmType;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.DiscrepancyAlarmTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17080")
public abstract class DiscrepancyAlarmTypeNodeBase
extends AlarmConditionTypeNode
implements DiscrepancyAlarmType {
    private static GeneratedNodeInitializer<DiscrepancyAlarmTypeNode> JN;

    protected DiscrepancyAlarmTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<DiscrepancyAlarmTypeNode> generatedNodeInitializer = DiscrepancyAlarmTypeNodeBase.getDiscrepancyAlarmTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DiscrepancyAlarmTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DiscrepancyAlarmTypeNode> getDiscrepancyAlarmTypeNodeInitializer() {
        return JN;
    }

    public static void setDiscrepancyAlarmTypeNodeInitializer(GeneratedNodeInitializer<DiscrepancyAlarmTypeNode> generatedNodeInitializer) {
        JN = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getExpectedTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExpectedTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getExpectedTime() {
        UaProperty uaProperty = this.getExpectedTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ExpectedTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setExpectedTime(Double d2) {
        UaProperty uaProperty = this.getExpectedTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExpectedTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ExpectedTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getToleranceNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Tolerance");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getTolerance() {
        UaProperty uaProperty = this.getToleranceNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setTolerance(Double d2) {
        UaProperty uaProperty = this.getToleranceNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Tolerance failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Tolerance failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getTargetValueNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TargetValueNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getTargetValueNode() {
        UaProperty uaProperty = this.getTargetValueNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node TargetValueNode does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setTargetValueNode(NodeId nodeId) {
        UaProperty uaProperty = this.getTargetValueNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TargetValueNode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TargetValueNode failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

