/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.TransmitQosDataType;
import com.prosysopc.ua.types.opcua.DatagramWriterGroupTransportType;
import com.prosysopc.ua.types.opcua.server.DatagramWriterGroupTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.NetworkAddressTypeNode;
import com.prosysopc.ua.types.opcua.server.WriterGroupTransportTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21133")
public abstract class DatagramWriterGroupTransportTypeNodeBase
extends WriterGroupTransportTypeNode
implements DatagramWriterGroupTransportType {
    private static GeneratedNodeInitializer<DatagramWriterGroupTransportTypeNode> JG;

    protected DatagramWriterGroupTransportTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getAddressNode());
        GeneratedNodeInitializer<DatagramWriterGroupTransportTypeNode> generatedNodeInitializer = DatagramWriterGroupTransportTypeNodeBase.getDatagramWriterGroupTransportTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DatagramWriterGroupTransportTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DatagramWriterGroupTransportTypeNode> getDatagramWriterGroupTransportTypeNodeInitializer() {
        return JG;
    }

    public static void setDatagramWriterGroupTransportTypeNodeInitializer(GeneratedNodeInitializer<DatagramWriterGroupTransportTypeNode> generatedNodeInitializer) {
        JG = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getMessageRepeatCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageRepeatCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedByte getMessageRepeatCount() {
        UaProperty uaProperty = this.getMessageRepeatCountNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Optional
    public void setMessageRepeatCount(UnsignedByte unsignedByte) {
        UaProperty uaProperty = this.getMessageRepeatCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MessageRepeatCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedByte);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MessageRepeatCount failed unexpectedly", statusException);
        }
    }

    public void setMessageRepeatCount(int n2) {
        this.setMessageRepeatCount(UnsignedByte.valueOf(n2));
    }

    @Override
    @Optional
    public UaProperty getTopicNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Topic");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getTopic() {
        UaProperty uaProperty = this.getTopicNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setTopic(String string) {
        UaProperty uaProperty = this.getTopicNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Topic failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Topic failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMessageRepeatDelayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageRepeatDelay");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getMessageRepeatDelay() {
        UaProperty uaProperty = this.getMessageRepeatDelayNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setMessageRepeatDelay(Double d2) {
        UaProperty uaProperty = this.getMessageRepeatDelayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MessageRepeatDelay failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MessageRepeatDelay failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDiscoveryAnnounceRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiscoveryAnnounceRate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getDiscoveryAnnounceRate() {
        UaProperty uaProperty = this.getDiscoveryAnnounceRateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setDiscoveryAnnounceRate(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getDiscoveryAnnounceRateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DiscoveryAnnounceRate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DiscoveryAnnounceRate failed unexpectedly", statusException);
        }
    }

    public void setDiscoveryAnnounceRate(long l2) {
        this.setDiscoveryAnnounceRate(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getDatagramQosNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DatagramQos");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public TransmitQosDataType[] getDatagramQos() {
        UaProperty uaProperty = this.getDatagramQosNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (TransmitQosDataType[])object;
    }

    @Override
    @Optional
    public void setDatagramQos(TransmitQosDataType[] transmitQosDataTypeArray) {
        UaProperty uaProperty = this.getDatagramQosNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DatagramQos failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(transmitQosDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DatagramQos failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getQosCategoryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "QosCategory");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getQosCategory() {
        UaProperty uaProperty = this.getQosCategoryNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setQosCategory(String string) {
        UaProperty uaProperty = this.getQosCategoryNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting QosCategory failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting QosCategory failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public NetworkAddressTypeNode getAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Address");
        return (NetworkAddressTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

