/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.DataItemType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.DataItemTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2365")
public abstract class DataItemTypeNodeBase
extends BaseDataVariableTypeNode
implements DataItemType {
    private static GeneratedNodeInitializer<DataItemTypeNode> Ji;

    protected DataItemTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<DataItemTypeNode> generatedNodeInitializer = DataItemTypeNodeBase.getDataItemTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DataItemTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DataItemTypeNode> getDataItemTypeNodeInitializer() {
        return Ji;
    }

    public static void setDataItemTypeNodeInitializer(GeneratedNodeInitializer<DataItemTypeNode> generatedNodeInitializer) {
        Ji = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Definition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDefinition() {
        UaProperty uaProperty = this.getDefinitionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDefinition(String string) {
        UaProperty uaProperty = this.getDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Definition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Definition failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getValuePrecisionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ValuePrecision");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getValuePrecision() {
        UaProperty uaProperty = this.getValuePrecisionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setValuePrecision(Double d2) {
        UaProperty uaProperty = this.getValuePrecisionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ValuePrecision failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ValuePrecision failed unexpectedly", statusException);
        }
    }
}

