/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.ConditionVariableType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.ConditionVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=9002")
public abstract class ConditionVariableTypeNodeBase
extends BaseDataVariableTypeNode
implements ConditionVariableType {
    private static GeneratedNodeInitializer<ConditionVariableTypeNode> Jf;

    protected ConditionVariableTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ConditionVariableTypeNode> generatedNodeInitializer = ConditionVariableTypeNodeBase.getConditionVariableTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ConditionVariableTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ConditionVariableTypeNode> getConditionVariableTypeNodeInitializer() {
        return Jf;
    }

    public static void setConditionVariableTypeNodeInitializer(GeneratedNodeInitializer<ConditionVariableTypeNode> generatedNodeInitializer) {
        Jf = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getSourceTimestampNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SourceTimestamp");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getSourceTimestamp() {
        UaProperty uaProperty = this.getSourceTimestampNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SourceTimestamp does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setSourceTimestamp(DateTime dateTime) {
        UaProperty uaProperty = this.getSourceTimestampNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SourceTimestamp failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SourceTimestamp failed unexpectedly", statusException);
        }
    }
}

