/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.types.opcua.CartesianCoordinatesType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.CartesianCoordinatesTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18772")
public abstract class CartesianCoordinatesTypeNodeBase
extends BaseDataVariableTypeNode
implements CartesianCoordinatesType {
    private static GeneratedNodeInitializer<CartesianCoordinatesTypeNode> IS;

    protected CartesianCoordinatesTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<CartesianCoordinatesTypeNode> generatedNodeInitializer = CartesianCoordinatesTypeNodeBase.getCartesianCoordinatesTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((CartesianCoordinatesTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<CartesianCoordinatesTypeNode> getCartesianCoordinatesTypeNodeInitializer() {
        return IS;
    }

    public static void setCartesianCoordinatesTypeNodeInitializer(GeneratedNodeInitializer<CartesianCoordinatesTypeNode> generatedNodeInitializer) {
        IS = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getLengthUnitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LengthUnit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EUInformation getLengthUnit() {
        UaProperty uaProperty = this.getLengthUnitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Optional
    public void setLengthUnit(EUInformation eUInformation) {
        UaProperty uaProperty = this.getLengthUnitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LengthUnit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(eUInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LengthUnit failed unexpectedly", statusException);
        }
    }
}

