/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.BrokerTransportQualityOfService;
import com.prosysopc.ua.types.opcua.BrokerDataSetWriterTransportType;
import com.prosysopc.ua.types.opcua.server.BrokerDataSetWriterTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.DataSetWriterTransportTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21138")
public abstract class BrokerDataSetWriterTransportTypeNodeBase
extends DataSetWriterTransportTypeNode
implements BrokerDataSetWriterTransportType {
    private static GeneratedNodeInitializer<BrokerDataSetWriterTransportTypeNode> IO;

    protected BrokerDataSetWriterTransportTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<BrokerDataSetWriterTransportTypeNode> generatedNodeInitializer = BrokerDataSetWriterTransportTypeNodeBase.getBrokerDataSetWriterTransportTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((BrokerDataSetWriterTransportTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<BrokerDataSetWriterTransportTypeNode> getBrokerDataSetWriterTransportTypeNodeInitializer() {
        return IO;
    }

    public static void setBrokerDataSetWriterTransportTypeNodeInitializer(GeneratedNodeInitializer<BrokerDataSetWriterTransportTypeNode> generatedNodeInitializer) {
        IO = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getQueueNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "QueueName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getQueueName() {
        UaProperty uaProperty = this.getQueueNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node QueueName does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setQueueName(String string) {
        UaProperty uaProperty = this.getQueueNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting QueueName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting QueueName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMetaDataUpdateTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MetaDataUpdateTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getMetaDataUpdateTime() {
        UaProperty uaProperty = this.getMetaDataUpdateTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MetaDataUpdateTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setMetaDataUpdateTime(Double d2) {
        UaProperty uaProperty = this.getMetaDataUpdateTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MetaDataUpdateTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MetaDataUpdateTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMetaDataQueueNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MetaDataQueueName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getMetaDataQueueName() {
        UaProperty uaProperty = this.getMetaDataQueueNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MetaDataQueueName does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setMetaDataQueueName(String string) {
        UaProperty uaProperty = this.getMetaDataQueueNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MetaDataQueueName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MetaDataQueueName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getAuthenticationProfileUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AuthenticationProfileUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getAuthenticationProfileUri() {
        UaProperty uaProperty = this.getAuthenticationProfileUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node AuthenticationProfileUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setAuthenticationProfileUri(String string) {
        UaProperty uaProperty = this.getAuthenticationProfileUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AuthenticationProfileUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AuthenticationProfileUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getResourceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResourceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getResourceUri() {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ResourceUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setResourceUri(String string) {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResourceUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ResourceUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRequestedDeliveryGuaranteeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestedDeliveryGuarantee");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public BrokerTransportQualityOfService getRequestedDeliveryGuarantee() {
        UaProperty uaProperty = this.getRequestedDeliveryGuaranteeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node RequestedDeliveryGuarantee does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (BrokerTransportQualityOfService)variant.asEnum(BrokerTransportQualityOfService.class);
    }

    @Override
    @Mandatory
    public void setRequestedDeliveryGuarantee(BrokerTransportQualityOfService brokerTransportQualityOfService) {
        UaProperty uaProperty = this.getRequestedDeliveryGuaranteeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RequestedDeliveryGuarantee failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(brokerTransportQualityOfService);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RequestedDeliveryGuarantee failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

