/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditSessionEventType;
import com.prosysopc.ua.types.opcua.server.AuditSecurityEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditSessionEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2069")
public abstract class AuditSessionEventTypeNodeBase
extends AuditSecurityEventTypeNode
implements AuditSessionEventType {
    private static GeneratedNodeInitializer<AuditSessionEventTypeNode> Ir;

    protected AuditSessionEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditSessionEventTypeNode> generatedNodeInitializer = AuditSessionEventTypeNodeBase.getAuditSessionEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditSessionEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditSessionEventTypeNode> getAuditSessionEventTypeNodeInitializer() {
        return Ir;
    }

    public static void setAuditSessionEventTypeNodeInitializer(GeneratedNodeInitializer<AuditSessionEventTypeNode> generatedNodeInitializer) {
        Ir = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getSessionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSessionId() {
        UaProperty uaProperty = this.getSessionIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SessionId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSessionId(NodeId nodeId) {
        UaProperty uaProperty = this.getSessionIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SessionId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionId failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

