/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditSecurityEventType;
import com.prosysopc.ua.types.opcua.server.AuditEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditSecurityEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2058")
public abstract class AuditSecurityEventTypeNodeBase
extends AuditEventTypeNode
implements AuditSecurityEventType {
    private static GeneratedNodeInitializer<AuditSecurityEventTypeNode> Iq;

    protected AuditSecurityEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditSecurityEventTypeNode> generatedNodeInitializer = AuditSecurityEventTypeNodeBase.getAuditSecurityEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditSecurityEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditSecurityEventTypeNode> getAuditSecurityEventTypeNodeInitializer() {
        return Iq;
    }

    public static void setAuditSecurityEventTypeNodeInitializer(GeneratedNodeInitializer<AuditSecurityEventTypeNode> generatedNodeInitializer) {
        Iq = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getStatusCodeIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StatusCodeId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public StatusCode getStatusCodeId() {
        UaProperty uaProperty = this.getStatusCodeIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (StatusCode)object;
    }

    @Override
    @Optional
    public void setStatusCodeId(StatusCode statusCode) {
        UaProperty uaProperty = this.getStatusCodeIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StatusCodeId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(statusCode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StatusCodeId failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

