/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditConditionConfirmEventType;
import com.prosysopc.ua.types.opcua.server.AuditConditionConfirmEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditConditionEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=8961")
public abstract class AuditConditionConfirmEventTypeNodeBase
extends AuditConditionEventTypeNode
implements AuditConditionConfirmEventType {
    private static GeneratedNodeInitializer<AuditConditionConfirmEventTypeNode> HQ;

    protected AuditConditionConfirmEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditConditionConfirmEventTypeNode> generatedNodeInitializer = AuditConditionConfirmEventTypeNodeBase.getAuditConditionConfirmEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditConditionConfirmEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditConditionConfirmEventTypeNode> getAuditConditionConfirmEventTypeNodeInitializer() {
        return HQ;
    }

    public static void setAuditConditionConfirmEventTypeNodeInitializer(GeneratedNodeInitializer<AuditConditionConfirmEventTypeNode> generatedNodeInitializer) {
        HQ = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getCommentNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Comment");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getComment() {
        UaProperty uaProperty = this.getCommentNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Comment does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setComment(LocalizedText localizedText) {
        UaProperty uaProperty = this.getCommentNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Comment failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Comment failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getConditionEventIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionEventId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getConditionEventId() {
        UaProperty uaProperty = this.getConditionEventIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ConditionEventId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setConditionEventId(ByteString byteString) {
        UaProperty uaProperty = this.getConditionEventIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionEventId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionEventId failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

