/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.types.opcua.AuditAddReferencesEventType;
import com.prosysopc.ua.types.opcua.server.AuditAddReferencesEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditNodeManagementEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2095")
public abstract class AuditAddReferencesEventTypeNodeBase
extends AuditNodeManagementEventTypeNode
implements AuditAddReferencesEventType {
    private static GeneratedNodeInitializer<AuditAddReferencesEventTypeNode> HA;

    protected AuditAddReferencesEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditAddReferencesEventTypeNode> generatedNodeInitializer = AuditAddReferencesEventTypeNodeBase.getAuditAddReferencesEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditAddReferencesEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditAddReferencesEventTypeNode> getAuditAddReferencesEventTypeNodeInitializer() {
        return HA;
    }

    public static void setAuditAddReferencesEventTypeNodeInitializer(GeneratedNodeInitializer<AuditAddReferencesEventTypeNode> generatedNodeInitializer) {
        HA = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getReferencesToAddNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ReferencesToAdd");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AddReferencesItem[] getReferencesToAdd() {
        UaProperty uaProperty = this.getReferencesToAddNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ReferencesToAdd does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AddReferencesItem[])object;
    }

    @Override
    @Mandatory
    public void setReferencesToAdd(AddReferencesItem[] addReferencesItemArray) {
        UaProperty uaProperty = this.getReferencesToAddNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ReferencesToAdd failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(addReferencesItemArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ReferencesToAdd failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

