/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.types.opcua.ApplicationConfigurationType;
import com.prosysopc.ua.types.opcua.server.ApplicationConfigurationTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=25731")
public abstract class ApplicationConfigurationTypeNodeBase
extends ServerConfigurationTypeNode
implements ApplicationConfigurationType {
    private static GeneratedNodeInitializer<ApplicationConfigurationTypeNode> Hv;

    protected ApplicationConfigurationTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ApplicationConfigurationTypeNode> generatedNodeInitializer = ApplicationConfigurationTypeNodeBase.getApplicationConfigurationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ApplicationConfigurationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ApplicationConfigurationTypeNode> getApplicationConfigurationTypeNodeInitializer() {
        return Hv;
    }

    public static void setApplicationConfigurationTypeNodeInitializer(GeneratedNodeInitializer<ApplicationConfigurationTypeNode> generatedNodeInitializer) {
        Hv = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getEnabledNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Enabled");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isEnabled() {
        UaProperty uaProperty = this.getEnabledNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Enabled does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setEnabled(Boolean bl) {
        UaProperty uaProperty = this.getEnabledNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Enabled failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Enabled failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getApplicationTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplicationType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ApplicationType getApplicationType() {
        UaProperty uaProperty = this.getApplicationTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ApplicationType does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (ApplicationType)variant.asEnum(ApplicationType.class);
    }

    @Override
    @Mandatory
    public void setApplicationType(ApplicationType applicationType) {
        UaProperty uaProperty = this.getApplicationTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ApplicationType failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(applicationType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ApplicationType failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getProductUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProductUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProductUri() {
        UaProperty uaProperty = this.getProductUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ProductUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProductUri(String string) {
        UaProperty uaProperty = this.getProductUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ProductUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ProductUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getApplicationUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplicationUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getApplicationUri() {
        UaProperty uaProperty = this.getApplicationUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ApplicationUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setApplicationUri(String string) {
        UaProperty uaProperty = this.getApplicationUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ApplicationUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ApplicationUri failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

