/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.types.opcua.AnalogUnitRangeType;
import com.prosysopc.ua.types.opcua.server.AnalogItemTypeNode;
import com.prosysopc.ua.types.opcua.server.AnalogUnitRangeTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17570")
public abstract class AnalogUnitRangeTypeNodeBase
extends AnalogItemTypeNode
implements AnalogUnitRangeType {
    private static GeneratedNodeInitializer<AnalogUnitRangeTypeNode> Hs;

    protected AnalogUnitRangeTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AnalogUnitRangeTypeNode> generatedNodeInitializer = AnalogUnitRangeTypeNodeBase.getAnalogUnitRangeTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AnalogUnitRangeTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AnalogUnitRangeTypeNode> getAnalogUnitRangeTypeNodeInitializer() {
        return Hs;
    }

    public static void setAnalogUnitRangeTypeNodeInitializer(GeneratedNodeInitializer<AnalogUnitRangeTypeNode> generatedNodeInitializer) {
        Hs = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getEngineeringUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EngineeringUnits");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public EUInformation getEngineeringUnits() {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EngineeringUnits does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Mandatory
    public void setEngineeringUnits(EUInformation eUInformation) {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EngineeringUnits failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(eUInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EngineeringUnits failed unexpectedly", statusException);
        }
    }
}

