/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.LinearConversionDataType;
import com.prosysopc.ua.types.opcua.AlternativeUnitType;
import com.prosysopc.ua.types.opcua.server.AlternativeUnitTypeNode;
import com.prosysopc.ua.types.opcua.server.UnitTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32467")
public abstract class AlternativeUnitTypeNodeBase
extends UnitTypeNode
implements AlternativeUnitType {
    private static GeneratedNodeInitializer<AlternativeUnitTypeNode> Hq;

    protected AlternativeUnitTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AlternativeUnitTypeNode> generatedNodeInitializer = AlternativeUnitTypeNodeBase.getAlternativeUnitTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AlternativeUnitTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AlternativeUnitTypeNode> getAlternativeUnitTypeNodeInitializer() {
        return Hq;
    }

    public static void setAlternativeUnitTypeNodeInitializer(GeneratedNodeInitializer<AlternativeUnitTypeNode> generatedNodeInitializer) {
        Hq = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getLinearConversionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LinearConversion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LinearConversionDataType getLinearConversion() {
        UaProperty uaProperty = this.getLinearConversionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LinearConversionDataType)object;
    }

    @Override
    @Optional
    public void setLinearConversion(LinearConversionDataType linearConversionDataType) {
        UaProperty uaProperty = this.getLinearConversionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LinearConversion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(linearConversionDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LinearConversion failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMathMLInverseConversionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MathMLInverseConversion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getMathMLInverseConversion() {
        UaProperty uaProperty = this.getMathMLInverseConversionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setMathMLInverseConversion(String string) {
        UaProperty uaProperty = this.getMathMLInverseConversionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MathMLInverseConversion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MathMLInverseConversion failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMathMLConversionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MathMLConversion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getMathMLConversion() {
        UaProperty uaProperty = this.getMathMLConversionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setMathMLConversion(String string) {
        UaProperty uaProperty = this.getMathMLConversionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MathMLConversion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MathMLConversion failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

