/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AlarmConditionType;
import com.prosysopc.ua.types.opcua.server.AcknowledgeableConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeGetGroupMembershipsMethod;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypePlaceInService2Method;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypePlaceInServiceMethod;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeRemoveFromService2Method;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeRemoveFromServiceMethod;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeReset2Method;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeResetMethod;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeSilenceMethod;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeSuppress2Method;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeSuppressMethod;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeUnsuppress2Method;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeUnsuppressMethod;
import com.prosysopc.ua.types.opcua.server.AlarmGroupTypeNode;
import com.prosysopc.ua.types.opcua.server.AudioVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2915")
public abstract class AlarmConditionTypeNodeBase
extends AcknowledgeableConditionTypeNode
implements AlarmConditionType {
    private static GeneratedNodeInitializer<AlarmConditionTypeNode> GU;
    private static AlarmConditionTypeUnsuppress2Method GV;
    private static AlarmConditionTypePlaceInService2Method GW;
    private static AlarmConditionTypePlaceInServiceMethod GX;
    private static AlarmConditionTypeSuppressMethod GY;
    private static AlarmConditionTypeRemoveFromServiceMethod GZ;
    private static AlarmConditionTypeRemoveFromService2Method Ha;
    private static AlarmConditionTypeSilenceMethod Hb;
    private static AlarmConditionTypeSuppress2Method Hc;
    private static AlarmConditionTypeReset2Method Hd;
    private static AlarmConditionTypeGetGroupMembershipsMethod He;
    private static AlarmConditionTypeResetMethod Hf;
    private static AlarmConditionTypeUnsuppressMethod Hg;

    protected AlarmConditionTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getAudibleSoundNode());
        this.callAfterCreateIfExists(this.getEnabledStateNode());
        this.callAfterCreateIfExists(this.getLatchedStateNode());
        this.callAfterCreateIfExists(this.getSilenceStateNode());
        this.callAfterCreateIfExists(this.getActiveStateNode());
        this.callAfterCreateIfExists(this.getSuppressedStateNode());
        this.callAfterCreateIfExists(this.getOutOfServiceStateNode());
        this.callAfterCreateIfExists(this.getFirstInGroupFlagNode());
        this.callAfterCreateIfExists(this.getReAlarmRepeatCountNode());
        this.callAfterCreateIfExists(this.getShelvingStateNode());
        this.callAfterCreateIfExists(this.getFirstInGroupNode());
        GeneratedNodeInitializer<AlarmConditionTypeNode> generatedNodeInitializer = AlarmConditionTypeNodeBase.getAlarmConditionTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AlarmConditionTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AlarmConditionTypeNode> getAlarmConditionTypeNodeInitializer() {
        return GU;
    }

    public static void setAlarmConditionTypeNodeInitializer(GeneratedNodeInitializer<AlarmConditionTypeNode> generatedNodeInitializer) {
        GU = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getMaxTimeShelvedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxTimeShelved");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getMaxTimeShelved() {
        UaProperty uaProperty = this.getMaxTimeShelvedNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setMaxTimeShelved(Double d2) {
        UaProperty uaProperty = this.getMaxTimeShelvedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxTimeShelved failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxTimeShelved failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getAudibleEnabledNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AudibleEnabled");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isAudibleEnabled() {
        UaProperty uaProperty = this.getAudibleEnabledNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setAudibleEnabled(Boolean bl) {
        UaProperty uaProperty = this.getAudibleEnabledNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AudibleEnabled failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AudibleEnabled failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSuppressedOrShelvedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SuppressedOrShelved");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isSuppressedOrShelved() {
        UaProperty uaProperty = this.getSuppressedOrShelvedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SuppressedOrShelved does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setSuppressedOrShelved(Boolean bl) {
        UaProperty uaProperty = this.getSuppressedOrShelvedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SuppressedOrShelved failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SuppressedOrShelved failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getOnDelayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OnDelay");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getOnDelay() {
        UaProperty uaProperty = this.getOnDelayNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setOnDelay(Double d2) {
        UaProperty uaProperty = this.getOnDelayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OnDelay failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting OnDelay failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getInputNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InputNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getInputNode() {
        UaProperty uaProperty = this.getInputNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node InputNode does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setInputNode(NodeId nodeId) {
        UaProperty uaProperty = this.getInputNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InputNode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting InputNode failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getOffDelayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OffDelay");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getOffDelay() {
        UaProperty uaProperty = this.getOffDelayNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setOffDelay(Double d2) {
        UaProperty uaProperty = this.getOffDelayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OffDelay failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting OffDelay failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getReAlarmTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ReAlarmTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getReAlarmTime() {
        UaProperty uaProperty = this.getReAlarmTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setReAlarmTime(Double d2) {
        UaProperty uaProperty = this.getReAlarmTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ReAlarmTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ReAlarmTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public AudioVariableTypeNode getAudibleSoundNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AudibleSound");
        return (AudioVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public ByteString getAudibleSound() {
        AudioVariableTypeNode audioVariableTypeNode = this.getAudibleSoundNode();
        if (audioVariableTypeNode == null) {
            return null;
        }
        Object object = audioVariableTypeNode.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Optional
    public void setAudibleSound(ByteString byteString) {
        AudioVariableTypeNode audioVariableTypeNode = this.getAudibleSoundNode();
        if (audioVariableTypeNode == null) {
            throw new RuntimeException("Setting AudibleSound failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            audioVariableTypeNode.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AudibleSound failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getEnabledStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node EnabledState does not exist");
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getEnabledStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting EnabledState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnabledState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getLatchedStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LatchedState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLatchedState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getLatchedStateNode();
        if (twoStateVariableTypeNode == null) {
            return null;
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLatchedState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getLatchedStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting LatchedState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LatchedState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getSilenceStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SilenceState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getSilenceState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getSilenceStateNode();
        if (twoStateVariableTypeNode == null) {
            return null;
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setSilenceState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getSilenceStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting SilenceState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SilenceState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getActiveStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActiveState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getActiveState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getActiveStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ActiveState does not exist");
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setActiveState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getActiveStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting ActiveState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ActiveState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getSuppressedStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SuppressedState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getSuppressedState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getSuppressedStateNode();
        if (twoStateVariableTypeNode == null) {
            return null;
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setSuppressedState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getSuppressedStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting SuppressedState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SuppressedState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getOutOfServiceStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OutOfServiceState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getOutOfServiceState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getOutOfServiceStateNode();
        if (twoStateVariableTypeNode == null) {
            return null;
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setOutOfServiceState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getOutOfServiceStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting OutOfServiceState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting OutOfServiceState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getFirstInGroupFlagNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FirstInGroupFlag");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isFirstInGroupFlag() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getFirstInGroupFlagNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setFirstInGroupFlag(Boolean bl) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getFirstInGroupFlagNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting FirstInGroupFlag failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting FirstInGroupFlag failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getReAlarmRepeatCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ReAlarmRepeatCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public Short getReAlarmRepeatCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getReAlarmRepeatCountNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Short)object;
    }

    @Override
    @Optional
    public void setReAlarmRepeatCount(Short s2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getReAlarmRepeatCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ReAlarmRepeatCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(s2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ReAlarmRepeatCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public ShelvedStateMachineTypeNode getShelvingStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ShelvingState");
        return (ShelvedStateMachineTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public AlarmGroupTypeNode getFirstInGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FirstInGroup");
        return (AlarmGroupTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Unsuppress2"), nodeId)) {
            this.a(serviceContext, (LocalizedText)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "PlaceInService2"), nodeId)) {
            this.b(serviceContext, (LocalizedText)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "PlaceInService"), nodeId)) {
            this.c(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Suppress"), nodeId)) {
            this.d(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveFromService"), nodeId)) {
            this.e(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveFromService2"), nodeId)) {
            this.c(serviceContext, (LocalizedText)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Silence"), nodeId)) {
            this.f(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Suppress2"), nodeId)) {
            this.d(serviceContext, (LocalizedText)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Reset2"), nodeId)) {
            this.e(serviceContext, (LocalizedText)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "GetGroupMemberships"), nodeId)) {
            return new Variant[]{new Variant(this.g(serviceContext))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Reset"), nodeId)) {
            this.h(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Unsuppress"), nodeId)) {
            this.i(serviceContext);
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getUnsuppress2Node() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Unsuppress2");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onUnsuppress2(ServiceContext var1, LocalizedText var2) throws StatusException;

    @Override
    public void unsuppress2(LocalizedText localizedText) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, localizedText);
    }

    private void a(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        AlarmConditionTypeUnsuppress2Method alarmConditionTypeUnsuppress2Method = AlarmConditionTypeNodeBase.getUnsuppress2MethodImplementation();
        if (alarmConditionTypeUnsuppress2Method != null) {
            alarmConditionTypeUnsuppress2Method.unsuppress2(serviceContext, (AlarmConditionTypeNode)this, localizedText);
        } else {
            this.onUnsuppress2(serviceContext, localizedText);
        }
    }

    public static AlarmConditionTypeUnsuppress2Method getUnsuppress2MethodImplementation() {
        return GV;
    }

    public static void setUnsuppress2MethodImplementation(AlarmConditionTypeUnsuppress2Method alarmConditionTypeUnsuppress2Method) {
        GV = alarmConditionTypeUnsuppress2Method;
    }

    @Override
    @Optional
    public UaMethod getPlaceInService2Node() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PlaceInService2");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onPlaceInService2(ServiceContext var1, LocalizedText var2) throws StatusException;

    @Override
    public void placeInService2(LocalizedText localizedText) throws StatusException {
        this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, localizedText);
    }

    private void b(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        AlarmConditionTypePlaceInService2Method alarmConditionTypePlaceInService2Method = AlarmConditionTypeNodeBase.getPlaceInService2MethodImplementation();
        if (alarmConditionTypePlaceInService2Method != null) {
            alarmConditionTypePlaceInService2Method.placeInService2(serviceContext, (AlarmConditionTypeNode)this, localizedText);
        } else {
            this.onPlaceInService2(serviceContext, localizedText);
        }
    }

    public static AlarmConditionTypePlaceInService2Method getPlaceInService2MethodImplementation() {
        return GW;
    }

    public static void setPlaceInService2MethodImplementation(AlarmConditionTypePlaceInService2Method alarmConditionTypePlaceInService2Method) {
        GW = alarmConditionTypePlaceInService2Method;
    }

    @Override
    @Optional
    public UaMethod getPlaceInServiceNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PlaceInService");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onPlaceInService(ServiceContext var1) throws StatusException;

    @Override
    public void placeInService() throws StatusException {
        this.c(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void c(ServiceContext serviceContext) throws StatusException {
        AlarmConditionTypePlaceInServiceMethod alarmConditionTypePlaceInServiceMethod = AlarmConditionTypeNodeBase.getPlaceInServiceMethodImplementation();
        if (alarmConditionTypePlaceInServiceMethod != null) {
            alarmConditionTypePlaceInServiceMethod.placeInService(serviceContext, (AlarmConditionTypeNode)this);
        } else {
            this.onPlaceInService(serviceContext);
        }
    }

    public static AlarmConditionTypePlaceInServiceMethod getPlaceInServiceMethodImplementation() {
        return GX;
    }

    public static void setPlaceInServiceMethodImplementation(AlarmConditionTypePlaceInServiceMethod alarmConditionTypePlaceInServiceMethod) {
        GX = alarmConditionTypePlaceInServiceMethod;
    }

    @Override
    @Optional
    public UaMethod getSuppressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Suppress");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onSuppress(ServiceContext var1) throws StatusException;

    @Override
    public void suppress() throws StatusException {
        this.d(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void d(ServiceContext serviceContext) throws StatusException {
        AlarmConditionTypeSuppressMethod alarmConditionTypeSuppressMethod = AlarmConditionTypeNodeBase.getSuppressMethodImplementation();
        if (alarmConditionTypeSuppressMethod != null) {
            alarmConditionTypeSuppressMethod.suppress(serviceContext, (AlarmConditionTypeNode)this);
        } else {
            this.onSuppress(serviceContext);
        }
    }

    public static AlarmConditionTypeSuppressMethod getSuppressMethodImplementation() {
        return GY;
    }

    public static void setSuppressMethodImplementation(AlarmConditionTypeSuppressMethod alarmConditionTypeSuppressMethod) {
        GY = alarmConditionTypeSuppressMethod;
    }

    @Override
    @Optional
    public UaMethod getRemoveFromServiceNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveFromService");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveFromService(ServiceContext var1) throws StatusException;

    @Override
    public void removeFromService() throws StatusException {
        this.e(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void e(ServiceContext serviceContext) throws StatusException {
        AlarmConditionTypeRemoveFromServiceMethod alarmConditionTypeRemoveFromServiceMethod = AlarmConditionTypeNodeBase.getRemoveFromServiceMethodImplementation();
        if (alarmConditionTypeRemoveFromServiceMethod != null) {
            alarmConditionTypeRemoveFromServiceMethod.removeFromService(serviceContext, (AlarmConditionTypeNode)this);
        } else {
            this.onRemoveFromService(serviceContext);
        }
    }

    public static AlarmConditionTypeRemoveFromServiceMethod getRemoveFromServiceMethodImplementation() {
        return GZ;
    }

    public static void setRemoveFromServiceMethodImplementation(AlarmConditionTypeRemoveFromServiceMethod alarmConditionTypeRemoveFromServiceMethod) {
        GZ = alarmConditionTypeRemoveFromServiceMethod;
    }

    @Override
    @Optional
    public UaMethod getRemoveFromService2Node() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveFromService2");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveFromService2(ServiceContext var1, LocalizedText var2) throws StatusException;

    @Override
    public void removeFromService2(LocalizedText localizedText) throws StatusException {
        this.c(ServiceContext.INTERNAL_OPERATION_CONTEXT, localizedText);
    }

    private void c(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        AlarmConditionTypeRemoveFromService2Method alarmConditionTypeRemoveFromService2Method = AlarmConditionTypeNodeBase.getRemoveFromService2MethodImplementation();
        if (alarmConditionTypeRemoveFromService2Method != null) {
            alarmConditionTypeRemoveFromService2Method.removeFromService2(serviceContext, (AlarmConditionTypeNode)this, localizedText);
        } else {
            this.onRemoveFromService2(serviceContext, localizedText);
        }
    }

    public static AlarmConditionTypeRemoveFromService2Method getRemoveFromService2MethodImplementation() {
        return Ha;
    }

    public static void setRemoveFromService2MethodImplementation(AlarmConditionTypeRemoveFromService2Method alarmConditionTypeRemoveFromService2Method) {
        Ha = alarmConditionTypeRemoveFromService2Method;
    }

    @Override
    @Optional
    public UaMethod getSilenceNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Silence");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onSilence(ServiceContext var1) throws StatusException;

    @Override
    public void silence() throws StatusException {
        this.f(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void f(ServiceContext serviceContext) throws StatusException {
        AlarmConditionTypeSilenceMethod alarmConditionTypeSilenceMethod = AlarmConditionTypeNodeBase.getSilenceMethodImplementation();
        if (alarmConditionTypeSilenceMethod != null) {
            alarmConditionTypeSilenceMethod.silence(serviceContext, (AlarmConditionTypeNode)this);
        } else {
            this.onSilence(serviceContext);
        }
    }

    public static AlarmConditionTypeSilenceMethod getSilenceMethodImplementation() {
        return Hb;
    }

    public static void setSilenceMethodImplementation(AlarmConditionTypeSilenceMethod alarmConditionTypeSilenceMethod) {
        Hb = alarmConditionTypeSilenceMethod;
    }

    @Override
    @Optional
    public UaMethod getSuppress2Node() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Suppress2");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onSuppress2(ServiceContext var1, LocalizedText var2) throws StatusException;

    @Override
    public void suppress2(LocalizedText localizedText) throws StatusException {
        this.d(ServiceContext.INTERNAL_OPERATION_CONTEXT, localizedText);
    }

    private void d(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        AlarmConditionTypeSuppress2Method alarmConditionTypeSuppress2Method = AlarmConditionTypeNodeBase.getSuppress2MethodImplementation();
        if (alarmConditionTypeSuppress2Method != null) {
            alarmConditionTypeSuppress2Method.suppress2(serviceContext, (AlarmConditionTypeNode)this, localizedText);
        } else {
            this.onSuppress2(serviceContext, localizedText);
        }
    }

    public static AlarmConditionTypeSuppress2Method getSuppress2MethodImplementation() {
        return Hc;
    }

    public static void setSuppress2MethodImplementation(AlarmConditionTypeSuppress2Method alarmConditionTypeSuppress2Method) {
        Hc = alarmConditionTypeSuppress2Method;
    }

    @Override
    @Optional
    public UaMethod getReset2Node() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Reset2");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onReset2(ServiceContext var1, LocalizedText var2) throws StatusException;

    @Override
    public void reset2(LocalizedText localizedText) throws StatusException {
        this.e(ServiceContext.INTERNAL_OPERATION_CONTEXT, localizedText);
    }

    private void e(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        AlarmConditionTypeReset2Method alarmConditionTypeReset2Method = AlarmConditionTypeNodeBase.getReset2MethodImplementation();
        if (alarmConditionTypeReset2Method != null) {
            alarmConditionTypeReset2Method.reset2(serviceContext, (AlarmConditionTypeNode)this, localizedText);
        } else {
            this.onReset2(serviceContext, localizedText);
        }
    }

    public static AlarmConditionTypeReset2Method getReset2MethodImplementation() {
        return Hd;
    }

    public static void setReset2MethodImplementation(AlarmConditionTypeReset2Method alarmConditionTypeReset2Method) {
        Hd = alarmConditionTypeReset2Method;
    }

    @Override
    @Optional
    public UaMethod getGetGroupMembershipsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GetGroupMemberships");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId[] onGetGroupMemberships(ServiceContext var1) throws StatusException;

    @Override
    public NodeId[] getGroupMemberships() throws StatusException {
        return this.g(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private NodeId[] g(ServiceContext serviceContext) throws StatusException {
        AlarmConditionTypeGetGroupMembershipsMethod alarmConditionTypeGetGroupMembershipsMethod = AlarmConditionTypeNodeBase.getGetGroupMembershipsMethodImplementation();
        if (alarmConditionTypeGetGroupMembershipsMethod != null) {
            return alarmConditionTypeGetGroupMembershipsMethod.getGroupMemberships(serviceContext, (AlarmConditionTypeNode)this);
        }
        return this.onGetGroupMemberships(serviceContext);
    }

    public static AlarmConditionTypeGetGroupMembershipsMethod getGetGroupMembershipsMethodImplementation() {
        return He;
    }

    public static void setGetGroupMembershipsMethodImplementation(AlarmConditionTypeGetGroupMembershipsMethod alarmConditionTypeGetGroupMembershipsMethod) {
        He = alarmConditionTypeGetGroupMembershipsMethod;
    }

    @Override
    @Optional
    public UaMethod getResetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Reset");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onReset(ServiceContext var1) throws StatusException;

    @Override
    public void reset() throws StatusException {
        this.h(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void h(ServiceContext serviceContext) throws StatusException {
        AlarmConditionTypeResetMethod alarmConditionTypeResetMethod = AlarmConditionTypeNodeBase.getResetMethodImplementation();
        if (alarmConditionTypeResetMethod != null) {
            alarmConditionTypeResetMethod.reset(serviceContext, (AlarmConditionTypeNode)this);
        } else {
            this.onReset(serviceContext);
        }
    }

    public static AlarmConditionTypeResetMethod getResetMethodImplementation() {
        return Hf;
    }

    public static void setResetMethodImplementation(AlarmConditionTypeResetMethod alarmConditionTypeResetMethod) {
        Hf = alarmConditionTypeResetMethod;
    }

    @Override
    @Optional
    public UaMethod getUnsuppressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Unsuppress");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onUnsuppress(ServiceContext var1) throws StatusException;

    @Override
    public void unsuppress() throws StatusException {
        this.i(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void i(ServiceContext serviceContext) throws StatusException {
        AlarmConditionTypeUnsuppressMethod alarmConditionTypeUnsuppressMethod = AlarmConditionTypeNodeBase.getUnsuppressMethodImplementation();
        if (alarmConditionTypeUnsuppressMethod != null) {
            alarmConditionTypeUnsuppressMethod.unsuppress(serviceContext, (AlarmConditionTypeNode)this);
        } else {
            this.onUnsuppress(serviceContext);
        }
    }

    public static AlarmConditionTypeUnsuppressMethod getUnsuppressMethodImplementation() {
        return Hg;
    }

    public static void setUnsuppressMethodImplementation(AlarmConditionTypeUnsuppressMethod alarmConditionTypeUnsuppressMethod) {
        Hg = alarmConditionTypeUnsuppressMethod;
    }
}

