/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNodeBase;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2915")
public class AlarmConditionTypeNode
extends AlarmConditionTypeNodeBase {
    private static final Logger logger = LoggerFactory.getLogger(AlarmConditionTypeNode.class);
    private UaVariable GT;

    protected AlarmConditionTypeNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        super.setInputNode(NodeId.NULL);
        ShelvedStateMachineTypeNode shelvedStateMachineTypeNode = this.getShelvingStateNode();
        if (shelvedStateMachineTypeNode != null) {
            shelvedStateMachineTypeNode.setCondition(this);
        }
        this.afterCreateInitIfExists(this.getActiveStateNode(), new LocalizedText("Active"), new LocalizedText("Inactive"), false);
        this.afterCreateInitIfExists(this.getSuppressedStateNode(), new LocalizedText("Suppressed"), new LocalizedText("Unsuppressed"), false);
    }

    public UaVariable getInput() {
        return this.GT;
    }

    @Override
    public NodeId getInputNode() {
        if (this.GT != null) {
            return this.GT.getNodeId();
        }
        return super.getInputNode();
    }

    public boolean isActive() {
        return this.getActiveStateNode().isId();
    }

    public void setActive(boolean bl) {
        this.setActive(bl, null);
    }

    public void setActive(boolean bl, DateTime dateTime) {
        ShelvedStateMachineTypeNode shelvedStateMachineTypeNode;
        boolean bl2 = this.isActive();
        this.getActiveStateNode().setId(bl, dateTime);
        if (bl2 && !bl && (shelvedStateMachineTypeNode = this.getShelvingStateNode()) != null && shelvedStateMachineTypeNode.isOneshotShelved()) {
            try {
                shelvedStateMachineTypeNode.unshelve();
            }
            catch (StatusException statusException) {
                logger.error("Error with unshelving on setActive: " + statusException);
            }
        }
    }

    public void setInput(UaVariable uaVariable) {
        this.GT = uaVariable;
    }

    @Override
    public void setInputNode(NodeId nodeId) {
        try {
            this.GT = (UaVariable)this.getNodeManager().getNode(nodeId);
        }
        catch (StatusException statusException) {
            this.GT = null;
        }
        catch (ClassCastException classCastException) {
            this.GT = null;
        }
        super.setInputNode(nodeId);
    }

    public void setMaxTimeShelved(double d2) {
        UaProperty uaProperty = this.getMaxTimeShelvedNode();
        if (uaProperty != null) {
            try {
                uaProperty.setValue(d2);
            }
            catch (StatusException statusException) {
                throw new RuntimeException("Setting MaxTimeShelved failed unexpectedly", statusException);
            }
        }
    }

    public void setSuppressed(boolean bl) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getSuppressedStateNode();
        if (twoStateVariableTypeNode != null) {
            twoStateVariableTypeNode.setId(bl);
        }
    }

    public void setSuppressedOrShelved(boolean bl) {
        super.setSuppressedOrShelved(bl);
    }

    @Override
    protected NodeId[] onGetGroupMemberships(ServiceContext serviceContext) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onPlaceInService(ServiceContext serviceContext) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onPlaceInService2(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onRemoveFromService(ServiceContext serviceContext) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onRemoveFromService2(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onReset(ServiceContext serviceContext) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onReset2(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onSilence(ServiceContext serviceContext) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onSuppress(ServiceContext serviceContext) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onSuppress2(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onUnsuppress(ServiceContext serviceContext) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onUnsuppress2(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }
}

