/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AggregateConfigurationType;
import com.prosysopc.ua.types.opcua.server.AggregateConfigurationTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11187")
public abstract class AggregateConfigurationTypeNodeBase
extends BaseObjectTypeNode
implements AggregateConfigurationType {
    private static GeneratedNodeInitializer<AggregateConfigurationTypeNode> GR;

    protected AggregateConfigurationTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AggregateConfigurationTypeNode> generatedNodeInitializer = AggregateConfigurationTypeNodeBase.getAggregateConfigurationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AggregateConfigurationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AggregateConfigurationTypeNode> getAggregateConfigurationTypeNodeInitializer() {
        return GR;
    }

    public static void setAggregateConfigurationTypeNodeInitializer(GeneratedNodeInitializer<AggregateConfigurationTypeNode> generatedNodeInitializer) {
        GR = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getPercentDataGoodNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PercentDataGood");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte getPercentDataGood() {
        UaProperty uaProperty = this.getPercentDataGoodNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PercentDataGood does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Mandatory
    public void setPercentDataGood(UnsignedByte unsignedByte) {
        UaProperty uaProperty = this.getPercentDataGoodNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PercentDataGood failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedByte);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PercentDataGood failed unexpectedly", statusException);
        }
    }

    public void setPercentDataGood(int n2) {
        this.setPercentDataGood(UnsignedByte.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getTreatUncertainAsBadNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TreatUncertainAsBad");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isTreatUncertainAsBad() {
        UaProperty uaProperty = this.getTreatUncertainAsBadNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node TreatUncertainAsBad does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setTreatUncertainAsBad(Boolean bl) {
        UaProperty uaProperty = this.getTreatUncertainAsBadNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TreatUncertainAsBad failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TreatUncertainAsBad failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getPercentDataBadNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PercentDataBad");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte getPercentDataBad() {
        UaProperty uaProperty = this.getPercentDataBadNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PercentDataBad does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Mandatory
    public void setPercentDataBad(UnsignedByte unsignedByte) {
        UaProperty uaProperty = this.getPercentDataBadNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PercentDataBad failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedByte);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PercentDataBad failed unexpectedly", statusException);
        }
    }

    public void setPercentDataBad(int n2) {
        this.setPercentDataBad(UnsignedByte.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getUseSlopedExtrapolationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UseSlopedExtrapolation");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isUseSlopedExtrapolation() {
        UaProperty uaProperty = this.getUseSlopedExtrapolationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node UseSlopedExtrapolation does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setUseSlopedExtrapolation(Boolean bl) {
        UaProperty uaProperty = this.getUseSlopedExtrapolationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UseSlopedExtrapolation failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UseSlopedExtrapolation failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

