/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.StateVariableType;
import com.prosysopc.ua.types.opcua.TransitionEventType;
import com.prosysopc.ua.types.opcua.TransitionVariableType;
import com.prosysopc.ua.types.opcua.client.BaseEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2311")
public abstract class TransitionEventTypeImplBase
extends BaseEventTypeImpl
implements TransitionEventType {
    protected TransitionEventTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public StateVariableType getToStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ToState");
        return (StateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getToState() {
        StateVariableType stateVariableType = this.getToStateNode();
        if (stateVariableType == null) {
            return null;
        }
        Object object = stateVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setToState(LocalizedText localizedText) throws StatusException {
        StateVariableType stateVariableType = this.getToStateNode();
        if (stateVariableType == null) {
            throw new RuntimeException("Setting ToState failed, the Optional node does not exist)");
        }
        stateVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public TransitionVariableType getTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Transition");
        return (TransitionVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTransition() {
        TransitionVariableType transitionVariableType = this.getTransitionNode();
        if (transitionVariableType == null) {
            return null;
        }
        Object object = transitionVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTransition(LocalizedText localizedText) throws StatusException {
        TransitionVariableType transitionVariableType = this.getTransitionNode();
        if (transitionVariableType == null) {
            throw new RuntimeException("Setting Transition failed, the Optional node does not exist)");
        }
        transitionVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public StateVariableType getFromStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FromState");
        return (StateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getFromState() {
        StateVariableType stateVariableType = this.getFromStateNode();
        if (stateVariableType == null) {
            return null;
        }
        Object object = stateVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setFromState(LocalizedText localizedText) throws StatusException {
        StateVariableType stateVariableType = this.getFromStateNode();
        if (stateVariableType == null) {
            throw new RuntimeException("Setting FromState failed, the Optional node does not exist)");
        }
        stateVariableType.setValue(localizedText);
    }
}

