/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.TransactionErrorType;
import com.prosysopc.ua.types.opcua.TransactionDiagnosticsType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32286")
public abstract class TransactionDiagnosticsTypeImplBase
extends BaseObjectTypeImpl
implements TransactionDiagnosticsType {
    protected TransactionDiagnosticsTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getStartTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getStartTime() {
        UaProperty uaProperty = this.getStartTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setStartTime(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getStartTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public UaProperty getAffectedCertificateGroupsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AffectedCertificateGroups");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId[] getAffectedCertificateGroups() {
        UaProperty uaProperty = this.getAffectedCertificateGroupsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Mandatory
    public void setAffectedCertificateGroups(NodeId[] nodeIdArray) throws StatusException {
        UaProperty uaProperty = this.getAffectedCertificateGroupsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AffectedCertificateGroups failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeIdArray);
    }

    @Override
    @Mandatory
    public UaProperty getEndTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getEndTime() {
        UaProperty uaProperty = this.getEndTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setEndTime(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getEndTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EndTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public UaProperty getAffectedTrustListsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AffectedTrustLists");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId[] getAffectedTrustLists() {
        UaProperty uaProperty = this.getAffectedTrustListsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Mandatory
    public void setAffectedTrustLists(NodeId[] nodeIdArray) throws StatusException {
        UaProperty uaProperty = this.getAffectedTrustListsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AffectedTrustLists failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeIdArray);
    }

    @Override
    @Mandatory
    public UaProperty getResultNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Result");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public StatusCode getResult() {
        UaProperty uaProperty = this.getResultNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (StatusCode)object;
    }

    @Override
    @Mandatory
    public void setResult(StatusCode statusCode) throws StatusException {
        UaProperty uaProperty = this.getResultNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Result failed, the Optional node does not exist)");
        }
        uaProperty.setValue(statusCode);
    }

    @Override
    @Mandatory
    public UaProperty getErrorsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Errors");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public TransactionErrorType[] getErrors() {
        UaProperty uaProperty = this.getErrorsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (TransactionErrorType[])object;
    }

    @Override
    @Mandatory
    public void setErrors(TransactionErrorType[] transactionErrorTypeArray) throws StatusException {
        UaProperty uaProperty = this.getErrorsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Errors failed, the Optional node does not exist)");
        }
        uaProperty.setValue(transactionErrorTypeArray);
    }
}

