/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.DataSetMetaDataType;
import com.prosysopc.ua.types.opcua.StandaloneSubscribedDataSetType;
import com.prosysopc.ua.types.opcua.SubscribedDataSetType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=23828")
public abstract class StandaloneSubscribedDataSetTypeImplBase
extends BaseObjectTypeImpl
implements StandaloneSubscribedDataSetType {
    protected StandaloneSubscribedDataSetTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetMetaDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetMetaData");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetMetaDataType getDataSetMetaData() {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DataSetMetaDataType)object;
    }

    @Override
    @Mandatory
    public void setDataSetMetaData(DataSetMetaDataType dataSetMetaDataType) throws StatusException {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetMetaData failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dataSetMetaDataType);
    }

    @Override
    @Mandatory
    public UaProperty getIsConnectedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IsConnected");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isIsConnected() {
        UaProperty uaProperty = this.getIsConnectedNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setIsConnected(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getIsConnectedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IsConnected failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public SubscribedDataSetType getSubscribedDataSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubscribedDataSet");
        return (SubscribedDataSetType)this.getComponent(qualifiedName);
    }
}

