/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ConversionLimitEnum;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import com.prosysopc.ua.types.opcua.ServerUnitType;
import com.prosysopc.ua.types.opcua.UnitType;
import com.prosysopc.ua.types.opcua.client.UnitTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32447")
public abstract class ServerUnitTypeImplBase
extends UnitTypeImpl
implements ServerUnitType {
    protected ServerUnitTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getConversionLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConversionLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ConversionLimitEnum getConversionLimit() {
        UaProperty uaProperty = this.getConversionLimitNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (ConversionLimitEnum)variant.asEnum(ConversionLimitEnum.class);
    }

    @Override
    @Mandatory
    public void setConversionLimit(ConversionLimitEnum conversionLimitEnum) throws StatusException {
        UaProperty uaProperty = this.getConversionLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConversionLimit failed, the Optional node does not exist)");
        }
        uaProperty.setValue(conversionLimitEnum);
    }

    @Override
    @Optional
    public BaseObjectType getAlternativeUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AlternativeUnits");
        return (BaseObjectType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public UnitType getCoherentUnitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CoherentUnit");
        return (UnitType)this.getComponent(qualifiedName);
    }
}

