/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.core.SignedSoftwareCertificate;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.OperationLimitsType;
import com.prosysopc.ua.types.opcua.RoleSetType;
import com.prosysopc.ua.types.opcua.ServerCapabilitiesType;
import com.prosysopc.ua.types.opcua.ServerVendorCapabilityType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import java.util.List;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2013")
public abstract class ServerCapabilitiesTypeImplBase
extends BaseObjectTypeImpl
implements ServerCapabilitiesType {
    protected ServerCapabilitiesTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getSoftwareCertificatesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SoftwareCertificates");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        UaProperty uaProperty = this.getSoftwareCertificatesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (SignedSoftwareCertificate[])object;
    }

    @Override
    @Mandatory
    public void setSoftwareCertificates(SignedSoftwareCertificate[] signedSoftwareCertificateArray) throws StatusException {
        UaProperty uaProperty = this.getSoftwareCertificatesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SoftwareCertificates failed, the Optional node does not exist)");
        }
        uaProperty.setValue(signedSoftwareCertificateArray);
    }

    @Override
    @Optional
    public UaProperty getMaxWhereClauseParametersNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxWhereClauseParameters");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxWhereClauseParameters() {
        UaProperty uaProperty = this.getMaxWhereClauseParametersNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxWhereClauseParameters(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxWhereClauseParametersNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxWhereClauseParameters failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getMaxSubscriptionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxSubscriptions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxSubscriptions() {
        UaProperty uaProperty = this.getMaxSubscriptionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxSubscriptions(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxSubscriptionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxSubscriptions failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public UaProperty getMaxHistoryContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxHistoryContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxHistoryContinuationPoints() {
        UaProperty uaProperty = this.getMaxHistoryContinuationPointsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxHistoryContinuationPoints(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getMaxHistoryContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxHistoryContinuationPoints failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Optional
    public UaProperty getMaxByteStringLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxByteStringLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxByteStringLength() {
        UaProperty uaProperty = this.getMaxByteStringLengthNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxByteStringLength(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxByteStringLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxByteStringLength failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public UaProperty getMaxBrowseContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxBrowseContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxBrowseContinuationPoints() {
        UaProperty uaProperty = this.getMaxBrowseContinuationPointsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxBrowseContinuationPoints(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getMaxBrowseContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxBrowseContinuationPoints failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Optional
    public UaProperty getMaxStringLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxStringLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxStringLength() {
        UaProperty uaProperty = this.getMaxStringLengthNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxStringLength(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxStringLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxStringLength failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getMaxSelectClauseParametersNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxSelectClauseParameters");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxSelectClauseParameters() {
        UaProperty uaProperty = this.getMaxSelectClauseParametersNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxSelectClauseParameters(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxSelectClauseParametersNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxSelectClauseParameters failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getMaxArrayLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxArrayLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxArrayLength() {
        UaProperty uaProperty = this.getMaxArrayLengthNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxArrayLength(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxArrayLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxArrayLength failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public UaProperty getServerProfileArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerProfileArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getServerProfileArray() {
        UaProperty uaProperty = this.getServerProfileArrayNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setServerProfileArray(String[] stringArray) throws StatusException {
        UaProperty uaProperty = this.getServerProfileArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerProfileArray failed, the Optional node does not exist)");
        }
        uaProperty.setValue(stringArray);
    }

    @Override
    @Optional
    public UaProperty getMaxMonitoredItemsQueueSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxMonitoredItemsQueueSize");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxMonitoredItemsQueueSize() {
        UaProperty uaProperty = this.getMaxMonitoredItemsQueueSizeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxMonitoredItemsQueueSize(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxMonitoredItemsQueueSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxMonitoredItemsQueueSize failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getMaxSessionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxSessions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxSessions() {
        UaProperty uaProperty = this.getMaxSessionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxSessions(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxSessionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxSessions failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getMaxMonitoredItemsPerSubscriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxMonitoredItemsPerSubscription");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxMonitoredItemsPerSubscription() {
        UaProperty uaProperty = this.getMaxMonitoredItemsPerSubscriptionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxMonitoredItemsPerSubscription(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxMonitoredItemsPerSubscriptionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxMonitoredItemsPerSubscription failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getMaxSubscriptionsPerSessionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxSubscriptionsPerSession");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxSubscriptionsPerSession() {
        UaProperty uaProperty = this.getMaxSubscriptionsPerSessionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxSubscriptionsPerSession(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxSubscriptionsPerSessionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxSubscriptionsPerSession failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getConformanceUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConformanceUnits");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public QualifiedName[] getConformanceUnits() {
        UaProperty uaProperty = this.getConformanceUnitsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (QualifiedName[])object;
    }

    @Override
    @Optional
    public void setConformanceUnits(QualifiedName[] qualifiedNameArray) throws StatusException {
        UaProperty uaProperty = this.getConformanceUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConformanceUnits failed, the Optional node does not exist)");
        }
        uaProperty.setValue(qualifiedNameArray);
    }

    @Override
    @Mandatory
    public UaProperty getMinSupportedSampleRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MinSupportedSampleRate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getMinSupportedSampleRate() {
        UaProperty uaProperty = this.getMinSupportedSampleRateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setMinSupportedSampleRate(Double d2) throws StatusException {
        UaProperty uaProperty = this.getMinSupportedSampleRateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MinSupportedSampleRate failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Optional
    public UaProperty getMaxMonitoredItemsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxMonitoredItems");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxMonitoredItems() {
        UaProperty uaProperty = this.getMaxMonitoredItemsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxMonitoredItems(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxMonitoredItemsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxMonitoredItems failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public UaProperty getLocaleIdArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocaleIdArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getLocaleIdArray() {
        UaProperty uaProperty = this.getLocaleIdArrayNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setLocaleIdArray(String[] stringArray) throws StatusException {
        UaProperty uaProperty = this.getLocaleIdArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LocaleIdArray failed, the Optional node does not exist)");
        }
        uaProperty.setValue(stringArray);
    }

    @Override
    @Mandatory
    public UaProperty getMaxQueryContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxQueryContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxQueryContinuationPoints() {
        UaProperty uaProperty = this.getMaxQueryContinuationPointsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxQueryContinuationPoints(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getMaxQueryContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxQueryContinuationPoints failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    public List<? extends ServerVendorCapabilityType> getVendorCapability_PlaceholderNodes() {
        ExpandedNodeId expandedNodeId = ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11562");
        ExpandedNodeId expandedNodeId2 = ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=47");
        return this.findPlaceholders(ServerVendorCapabilityType.class, expandedNodeId, expandedNodeId2);
    }

    @Override
    @Mandatory
    public FolderType getModellingRulesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ModellingRules");
        return (FolderType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public FolderType getAggregateFunctionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AggregateFunctions");
        return (FolderType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public OperationLimitsType getOperationLimitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OperationLimits");
        return (OperationLimitsType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public RoleSetType getRoleSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RoleSet");
        return (RoleSetType)this.getComponent(qualifiedName);
    }
}

