/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodArgumentTransformer;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.EndpointType;
import com.prosysopc.ua.stack.core.IdentityMappingRuleType;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.types.opcua.RoleType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15620")
public abstract class RoleTypeImplBase
extends BaseObjectTypeImpl
implements RoleType {
    protected RoleTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getEndpointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Endpoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EndpointType[] getEndpoints() {
        UaProperty uaProperty = this.getEndpointsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EndpointType[])object;
    }

    @Override
    @Optional
    public void setEndpoints(EndpointType[] endpointTypeArray) throws StatusException {
        UaProperty uaProperty = this.getEndpointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Endpoints failed, the Optional node does not exist)");
        }
        uaProperty.setValue(endpointTypeArray);
    }

    @Override
    @Optional
    public UaProperty getApplicationsExcludeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplicationsExclude");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isApplicationsExclude() {
        UaProperty uaProperty = this.getApplicationsExcludeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setApplicationsExclude(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getApplicationsExcludeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ApplicationsExclude failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Optional
    public UaProperty getCustomConfigurationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CustomConfiguration");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isCustomConfiguration() {
        UaProperty uaProperty = this.getCustomConfigurationNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setCustomConfiguration(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getCustomConfigurationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CustomConfiguration failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Optional
    public UaProperty getApplicationsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Applications");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String[] getApplications() {
        UaProperty uaProperty = this.getApplicationsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Optional
    public void setApplications(String[] stringArray) throws StatusException {
        UaProperty uaProperty = this.getApplicationsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Applications failed, the Optional node does not exist)");
        }
        uaProperty.setValue(stringArray);
    }

    @Override
    @Mandatory
    public UaProperty getIdentitiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Identities");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public IdentityMappingRuleType[] getIdentities() {
        UaProperty uaProperty = this.getIdentitiesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (IdentityMappingRuleType[])object;
    }

    @Override
    @Mandatory
    public void setIdentities(IdentityMappingRuleType[] identityMappingRuleTypeArray) throws StatusException {
        UaProperty uaProperty = this.getIdentitiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Identities failed, the Optional node does not exist)");
        }
        uaProperty.setValue(identityMappingRuleTypeArray);
    }

    @Override
    @Optional
    public UaProperty getEndpointsExcludeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndpointsExclude");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isEndpointsExclude() {
        UaProperty uaProperty = this.getEndpointsExcludeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setEndpointsExclude(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getEndpointsExcludeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EndpointsExclude failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Optional
    public UaMethod getAddEndpointNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddEndpoint");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void addEndpoint(EndpointType endpointType) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddEndpoint"));
        this.call(nodeId, endpointType);
    }

    public AsyncResult<Void> addEndpointAsync(EndpointType endpointType) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddEndpoint"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, endpointType);
    }

    @Override
    @Optional
    public UaMethod getAddIdentityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddIdentity");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void addIdentity(IdentityMappingRuleType identityMappingRuleType) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddIdentity"));
        this.call(nodeId, identityMappingRuleType);
    }

    public AsyncResult<Void> addIdentityAsync(IdentityMappingRuleType identityMappingRuleType) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddIdentity"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, identityMappingRuleType);
    }

    @Override
    @Optional
    public UaMethod getRemoveApplicationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveApplication");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void removeApplication(String string) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveApplication"));
        this.call(nodeId, string);
    }

    public AsyncResult<Void> removeApplicationAsync(String string) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveApplication"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, string);
    }

    @Override
    @Optional
    public UaMethod getRemoveEndpointNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveEndpoint");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void removeEndpoint(EndpointType endpointType) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveEndpoint"));
        this.call(nodeId, endpointType);
    }

    public AsyncResult<Void> removeEndpointAsync(EndpointType endpointType) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveEndpoint"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, endpointType);
    }

    @Override
    @Optional
    public UaMethod getRemoveIdentityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveIdentity");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void removeIdentity(IdentityMappingRuleType identityMappingRuleType) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveIdentity"));
        this.call(nodeId, identityMappingRuleType);
    }

    public AsyncResult<Void> removeIdentityAsync(IdentityMappingRuleType identityMappingRuleType) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveIdentity"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, identityMappingRuleType);
    }

    @Override
    @Optional
    public UaMethod getAddApplicationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddApplication");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void addApplication(String string) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddApplication"));
        this.call(nodeId, string);
    }

    public AsyncResult<Void> addApplicationAsync(String string) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddApplication"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, string);
    }
}

