/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.InterfaceAdminStatus;
import com.prosysopc.ua.stack.core.InterfaceOperStatus;
import com.prosysopc.ua.types.opcua.AnalogUnitType;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.IetfBaseNetworkInterfaceType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=25221")
public abstract class IetfBaseNetworkInterfaceTypeImplBase
extends BaseObjectTypeImpl
implements IetfBaseNetworkInterfaceType {
    protected IetfBaseNetworkInterfaceTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getAdminStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AdminStatus");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public InterfaceAdminStatus getAdminStatus() {
        BaseDataVariableType baseDataVariableType = this.getAdminStatusNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Variant variant = baseDataVariableType.getValue().getValue();
        return (InterfaceAdminStatus)variant.asEnum(InterfaceAdminStatus.class);
    }

    @Override
    @Mandatory
    public void setAdminStatus(InterfaceAdminStatus interfaceAdminStatus) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getAdminStatusNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting AdminStatus failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(interfaceAdminStatus);
    }

    @Override
    @Optional
    public BaseDataVariableType getPhysAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PhysAddress");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public String getPhysAddress() {
        BaseDataVariableType baseDataVariableType = this.getPhysAddressNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setPhysAddress(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getPhysAddressNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting PhysAddress failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getOperStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OperStatus");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public InterfaceOperStatus getOperStatus() {
        BaseDataVariableType baseDataVariableType = this.getOperStatusNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Variant variant = baseDataVariableType.getValue().getValue();
        return (InterfaceOperStatus)variant.asEnum(InterfaceOperStatus.class);
    }

    @Override
    @Mandatory
    public void setOperStatus(InterfaceOperStatus interfaceOperStatus) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getOperStatusNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting OperStatus failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(interfaceOperStatus);
    }

    @Override
    @Mandatory
    public AnalogUnitType getSpeedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Speed");
        return (AnalogUnitType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedLong getSpeed() {
        AnalogUnitType analogUnitType = this.getSpeedNode();
        if (analogUnitType == null) {
            return null;
        }
        Object object = analogUnitType.getValue().getValue().getValue();
        return (UnsignedLong)object;
    }

    @Override
    @Mandatory
    public void setSpeed(UnsignedLong unsignedLong) throws StatusException {
        AnalogUnitType analogUnitType = this.getSpeedNode();
        if (analogUnitType == null) {
            throw new RuntimeException("Setting Speed failed, the Optional node does not exist)");
        }
        analogUnitType.setValue(unsignedLong);
    }
}

