/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.TsnStreamState;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.IIeeeBaseTsnStreamType;
import com.prosysopc.ua.types.opcua.client.BaseInterfaceTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24173")
public abstract class IIeeeBaseTsnStreamTypeImplBase
extends BaseInterfaceTypeImpl
implements IIeeeBaseTsnStreamType {
    protected IIeeeBaseTsnStreamTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getStreamIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StreamId");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte[] getStreamId() {
        BaseDataVariableType baseDataVariableType = this.getStreamIdNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (UnsignedByte[])object;
    }

    @Override
    @Mandatory
    public void setStreamId(UnsignedByte[] unsignedByteArray) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getStreamIdNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting StreamId failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(unsignedByteArray);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "State");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public TsnStreamState getState() {
        BaseDataVariableType baseDataVariableType = this.getStateNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Variant variant = baseDataVariableType.getValue().getValue();
        return (TsnStreamState)variant.asEnum(TsnStreamState.class);
    }

    @Override
    @Mandatory
    public void setState(TsnStreamState tsnStreamState) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getStateNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting State failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(tsnStreamState);
    }

    @Override
    @Optional
    public BaseDataVariableType getAccumulatedLatencyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AccumulatedLatency");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getAccumulatedLatency() {
        BaseDataVariableType baseDataVariableType = this.getAccumulatedLatencyNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setAccumulatedLatency(UnsignedInteger unsignedInteger) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getAccumulatedLatencyNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting AccumulatedLatency failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public BaseDataVariableType getSrClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SrClassId");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedByte getSrClassId() {
        BaseDataVariableType baseDataVariableType = this.getSrClassIdNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Optional
    public void setSrClassId(UnsignedByte unsignedByte) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSrClassIdNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SrClassId failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(unsignedByte);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getStreamNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StreamName");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getStreamName() {
        BaseDataVariableType baseDataVariableType = this.getStreamNameNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setStreamName(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getStreamNameNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting StreamName failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }
}

