/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.types.opcua.HistoricalExternalEventSourceType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32625")
public abstract class HistoricalExternalEventSourceTypeImplBase
extends BaseObjectTypeImpl
implements HistoricalExternalEventSourceType {
    protected HistoricalExternalEventSourceTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getIdentityTokenPolicyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IdentityTokenPolicy");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UserTokenPolicy getIdentityTokenPolicy() {
        UaProperty uaProperty = this.getIdentityTokenPolicyNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UserTokenPolicy)object;
    }

    @Override
    @Optional
    public void setIdentityTokenPolicy(UserTokenPolicy userTokenPolicy) throws StatusException {
        UaProperty uaProperty = this.getIdentityTokenPolicyNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IdentityTokenPolicy failed, the Optional node does not exist)");
        }
        uaProperty.setValue(userTokenPolicy);
    }

    @Override
    @Optional
    public UaProperty getTransportProfileUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportProfileUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getTransportProfileUri() {
        UaProperty uaProperty = this.getTransportProfileUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setTransportProfileUri(String string) throws StatusException {
        UaProperty uaProperty = this.getTransportProfileUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TransportProfileUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getHistoricalEventFilterNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HistoricalEventFilter");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public EventFilter getHistoricalEventFilter() {
        UaProperty uaProperty = this.getHistoricalEventFilterNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EventFilter)object;
    }

    @Override
    @Mandatory
    public void setHistoricalEventFilter(EventFilter eventFilter) throws StatusException {
        UaProperty uaProperty = this.getHistoricalEventFilterNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HistoricalEventFilter failed, the Optional node does not exist)");
        }
        uaProperty.setValue(eventFilter);
    }

    @Override
    @Optional
    public UaProperty getSecurityPolicyUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityPolicyUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getSecurityPolicyUri() {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSecurityPolicyUri(String string) throws StatusException {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityPolicyUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public MessageSecurityMode getSecurityMode() {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (MessageSecurityMode)variant.asEnum(MessageSecurityMode.class);
    }

    @Override
    @Optional
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) throws StatusException {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityMode failed, the Optional node does not exist)");
        }
        uaProperty.setValue(messageSecurityMode);
    }

    @Override
    @Optional
    public UaProperty getEndpointUrlNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndpointUrl");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getEndpointUrl() {
        UaProperty uaProperty = this.getEndpointUrlNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setEndpointUrl(String string) throws StatusException {
        UaProperty uaProperty = this.getEndpointUrlNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EndpointUrl failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getServerNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Server");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getServer() {
        UaProperty uaProperty = this.getServerNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setServer(String string) throws StatusException {
        UaProperty uaProperty = this.getServerNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Server failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }
}

