/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.DataItemType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2365")
public abstract class DataItemTypeImplBase
extends BaseDataVariableTypeImpl
implements DataItemType {
    protected DataItemTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Definition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDefinition() {
        UaProperty uaProperty = this.getDefinitionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDefinition(String string) throws StatusException {
        UaProperty uaProperty = this.getDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Definition failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getValuePrecisionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ValuePrecision");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getValuePrecision() {
        UaProperty uaProperty = this.getValuePrecisionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setValuePrecision(Double d2) throws StatusException {
        UaProperty uaProperty = this.getValuePrecisionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ValuePrecision failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }
}

