/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.core.TimeZoneDataType;
import com.prosysopc.ua.types.opcua.BaseEventType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2041")
public abstract class BaseEventTypeImplBase
extends BaseObjectTypeImpl
implements BaseEventType {
    protected BaseEventTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Time");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getTime() {
        UaProperty uaProperty = this.getTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setTime(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Time failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public UaProperty getMessageNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Message");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getMessage() {
        UaProperty uaProperty = this.getMessageNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setMessage(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getMessageNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Message failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Optional
    public UaProperty getConditionSubClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionSubClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public NodeId[] getConditionSubClassId() {
        UaProperty uaProperty = this.getConditionSubClassIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Optional
    public void setConditionSubClassId(NodeId[] nodeIdArray) throws StatusException {
        UaProperty uaProperty = this.getConditionSubClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionSubClassId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeIdArray);
    }

    @Override
    @Mandatory
    public UaProperty getSourceNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SourceNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSourceNode() {
        UaProperty uaProperty = this.getSourceNodeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSourceNode(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getSourceNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SourceNode failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Optional
    public UaProperty getConditionClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public NodeId getConditionClassId() {
        UaProperty uaProperty = this.getConditionClassIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Optional
    public void setConditionClassId(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getConditionClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionClassId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Optional
    public UaProperty getLocalTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocalTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public TimeZoneDataType getLocalTime() {
        UaProperty uaProperty = this.getLocalTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (TimeZoneDataType)object;
    }

    @Override
    @Optional
    public void setLocalTime(TimeZoneDataType timeZoneDataType) throws StatusException {
        UaProperty uaProperty = this.getLocalTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LocalTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(timeZoneDataType);
    }

    @Override
    @Mandatory
    public UaProperty getEventIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getEventId() {
        UaProperty uaProperty = this.getEventIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setEventId(ByteString byteString) throws StatusException {
        UaProperty uaProperty = this.getEventIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EventId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(byteString);
    }

    @Override
    @Optional
    public UaProperty getConditionSubClassNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionSubClassName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText[] getConditionSubClassName() {
        UaProperty uaProperty = this.getConditionSubClassNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Optional
    public void setConditionSubClassName(LocalizedText[] localizedTextArray) throws StatusException {
        UaProperty uaProperty = this.getConditionSubClassNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionSubClassName failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedTextArray);
    }

    @Override
    @Mandatory
    public UaProperty getSeverityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Severity");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getSeverity() {
        UaProperty uaProperty = this.getSeverityNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setSeverity(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getSeverityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Severity failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Optional
    public UaProperty getConditionClassNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionClassName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getConditionClassName() {
        UaProperty uaProperty = this.getConditionClassNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setConditionClassName(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getConditionClassNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionClassName failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getReceiveTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ReceiveTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getReceiveTime() {
        UaProperty uaProperty = this.getReceiveTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setReceiveTime(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getReceiveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ReceiveTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public UaProperty getSourceNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SourceName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSourceName() {
        UaProperty uaProperty = this.getSourceNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSourceName(String string) throws StatusException {
        UaProperty uaProperty = this.getSourceNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SourceName failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getEventTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getEventType() {
        UaProperty uaProperty = this.getEventTypeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setEventType(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getEventTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EventType failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }
}

