/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.types.opcua.AuditProgramTransitionEventType;
import com.prosysopc.ua.types.opcua.client.AuditUpdateStateEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11856")
public abstract class AuditProgramTransitionEventTypeImplBase
extends AuditUpdateStateEventTypeImpl
implements AuditProgramTransitionEventType {
    protected AuditProgramTransitionEventTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getTransitionNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransitionNumber");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTransitionNumber() {
        UaProperty uaProperty = this.getTransitionNumberNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTransitionNumber(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getTransitionNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TransitionNumber failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }
}

