/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AxisScaleEnumeration;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.stack.core.Range;
import com.prosysopc.ua.types.opcua.ArrayItemType;
import com.prosysopc.ua.types.opcua.client.DataItemTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12021")
public abstract class ArrayItemTypeImplBase
extends DataItemTypeImpl
implements ArrayItemType {
    protected ArrayItemTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getEURangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EURange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Range getEURange() {
        UaProperty uaProperty = this.getEURangeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Mandatory
    public void setEURange(Range range) throws StatusException {
        UaProperty uaProperty = this.getEURangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EURange failed, the Optional node does not exist)");
        }
        uaProperty.setValue(range);
    }

    @Override
    @Optional
    public UaProperty getInstrumentRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InstrumentRange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Range getInstrumentRange() {
        UaProperty uaProperty = this.getInstrumentRangeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Optional
    public void setInstrumentRange(Range range) throws StatusException {
        UaProperty uaProperty = this.getInstrumentRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InstrumentRange failed, the Optional node does not exist)");
        }
        uaProperty.setValue(range);
    }

    @Override
    @Mandatory
    public UaProperty getAxisScaleTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AxisScaleType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisScaleEnumeration getAxisScaleType() {
        UaProperty uaProperty = this.getAxisScaleTypeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (AxisScaleEnumeration)variant.asEnum(AxisScaleEnumeration.class);
    }

    @Override
    @Mandatory
    public void setAxisScaleType(AxisScaleEnumeration axisScaleEnumeration) throws StatusException {
        UaProperty uaProperty = this.getAxisScaleTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AxisScaleType failed, the Optional node does not exist)");
        }
        uaProperty.setValue(axisScaleEnumeration);
    }

    @Override
    @Mandatory
    public UaProperty getTitleNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Title");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTitle() {
        UaProperty uaProperty = this.getTitleNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTitle(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getTitleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Title failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getEngineeringUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EngineeringUnits");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public EUInformation getEngineeringUnits() {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Mandatory
    public void setEngineeringUnits(EUInformation eUInformation) throws StatusException {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EngineeringUnits failed, the Optional node does not exist)");
        }
        uaProperty.setValue(eUInformation);
    }
}

