/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.LinearConversionDataType;
import com.prosysopc.ua.types.opcua.AlternativeUnitType;
import com.prosysopc.ua.types.opcua.client.UnitTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32467")
public abstract class AlternativeUnitTypeImplBase
extends UnitTypeImpl
implements AlternativeUnitType {
    protected AlternativeUnitTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getLinearConversionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LinearConversion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LinearConversionDataType getLinearConversion() {
        UaProperty uaProperty = this.getLinearConversionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LinearConversionDataType)object;
    }

    @Override
    @Optional
    public void setLinearConversion(LinearConversionDataType linearConversionDataType) throws StatusException {
        UaProperty uaProperty = this.getLinearConversionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LinearConversion failed, the Optional node does not exist)");
        }
        uaProperty.setValue(linearConversionDataType);
    }

    @Override
    @Optional
    public UaProperty getMathMLInverseConversionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MathMLInverseConversion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getMathMLInverseConversion() {
        UaProperty uaProperty = this.getMathMLInverseConversionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setMathMLInverseConversion(String string) throws StatusException {
        UaProperty uaProperty = this.getMathMLInverseConversionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MathMLInverseConversion failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getMathMLConversionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MathMLConversion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getMathMLConversion() {
        UaProperty uaProperty = this.getMathMLConversionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setMathMLConversion(String string) throws StatusException {
        UaProperty uaProperty = this.getMathMLConversionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MathMLConversion failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }
}

