/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua;

import com.prosysopc.ua.MethodOutputArguments;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.core.ServerStatusDataType;
import com.prosysopc.ua.stack.core.TimeZoneDataType;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import com.prosysopc.ua.types.opcua.NamespacesType;
import com.prosysopc.ua.types.opcua.ServerCapabilitiesType;
import com.prosysopc.ua.types.opcua.ServerDiagnosticsType;
import com.prosysopc.ua.types.opcua.ServerRedundancyType;
import com.prosysopc.ua.types.opcua.ServerStatusType;
import com.prosysopc.ua.types.opcua.VendorServerInfoType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2004")
public interface ServerType
extends BaseObjectType {
    public static final String SERVER_ARRAY = "ServerArray";
    public static final String AUDITING = "Auditing";
    public static final String ESTIMATED_RETURN_TIME = "EstimatedReturnTime";
    public static final String URIS_VERSION = "UrisVersion";
    public static final String LOCAL_TIME = "LocalTime";
    public static final String NAMESPACE_ARRAY = "NamespaceArray";
    public static final String SERVICE_LEVEL = "ServiceLevel";
    public static final String SERVER_DIAGNOSTICS = "ServerDiagnostics";
    public static final String SERVER_REDUNDANCY = "ServerRedundancy";
    public static final String NAMESPACES = "Namespaces";
    public static final String VENDOR_SERVER_INFO = "VendorServerInfo";
    public static final String SERVER_CAPABILITIES = "ServerCapabilities";
    public static final String SERVER_STATUS = "ServerStatus";
    public static final String GET_MONITORED_ITEMS = "GetMonitoredItems";
    public static final String SET_SUBSCRIPTION_DURABLE = "SetSubscriptionDurable";
    public static final String REQUEST_SERVER_STATE_CHANGE = "RequestServerStateChange";
    public static final String RESEND_DATA = "ResendData";

    @Mandatory
    public UaProperty getServerArrayNode();

    @Mandatory
    public String[] getServerArray();

    @Mandatory
    public void setServerArray(String[] var1) throws StatusException;

    @Mandatory
    public UaProperty getAuditingNode();

    @Mandatory
    public Boolean isAuditing();

    @Mandatory
    public void setAuditing(Boolean var1) throws StatusException;

    @Optional
    public UaProperty getEstimatedReturnTimeNode();

    @Optional
    public DateTime getEstimatedReturnTime();

    @Optional
    public void setEstimatedReturnTime(DateTime var1) throws StatusException;

    @Optional
    public UaProperty getUrisVersionNode();

    @Optional
    public UnsignedInteger getUrisVersion();

    @Optional
    public void setUrisVersion(UnsignedInteger var1) throws StatusException;

    @Optional
    public UaProperty getLocalTimeNode();

    @Optional
    public TimeZoneDataType getLocalTime();

    @Optional
    public void setLocalTime(TimeZoneDataType var1) throws StatusException;

    @Mandatory
    public UaProperty getNamespaceArrayNode();

    @Mandatory
    public String[] getNamespaceArray();

    @Mandatory
    public void setNamespaceArray(String[] var1) throws StatusException;

    @Mandatory
    public UaProperty getServiceLevelNode();

    @Mandatory
    public UnsignedByte getServiceLevel();

    @Mandatory
    public void setServiceLevel(UnsignedByte var1) throws StatusException;

    @Mandatory
    public ServerStatusType getServerStatusNode();

    @Mandatory
    public ServerStatusDataType getServerStatus();

    @Mandatory
    public void setServerStatus(ServerStatusDataType var1) throws StatusException;

    @Mandatory
    public ServerDiagnosticsType getServerDiagnosticsNode();

    @Mandatory
    public ServerRedundancyType getServerRedundancyNode();

    @Optional
    public NamespacesType getNamespacesNode();

    @Mandatory
    public VendorServerInfoType getVendorServerInfoNode();

    @Mandatory
    public ServerCapabilitiesType getServerCapabilitiesNode();

    @Optional
    public UaMethod getGetMonitoredItemsNode();

    public GetMonitoredItemsMethodOutputs getMonitoredItems(UnsignedInteger var1) throws StatusException, ServiceException;

    @Optional
    public UaMethod getSetSubscriptionDurableNode();

    public UnsignedInteger setSubscriptionDurable(UnsignedInteger var1, UnsignedInteger var2) throws StatusException, ServiceException;

    @Optional
    public UaMethod getRequestServerStateChangeNode();

    public void requestServerStateChange(ServerState var1, DateTime var2, UnsignedInteger var3, LocalizedText var4, Boolean var5) throws StatusException, ServiceException;

    @Optional
    public UaMethod getResendDataNode();

    public void resendData(UnsignedInteger var1) throws StatusException, ServiceException;

    public static class GetMonitoredItemsMethodOutputs
    implements MethodOutputArguments {
        protected UnsignedInteger[] f_serverHandles;
        protected UnsignedInteger[] f_clientHandles;

        public GetMonitoredItemsMethodOutputs(UnsignedInteger[] unsignedIntegerArray, UnsignedInteger[] unsignedIntegerArray2) {
            this.f_serverHandles = unsignedIntegerArray;
            this.f_clientHandles = unsignedIntegerArray2;
        }

        public UnsignedInteger[] getServerHandles() {
            return this.f_serverHandles;
        }

        public UnsignedInteger[] getClientHandles() {
            return this.f_clientHandles;
        }

        @Override
        public final Variant[] asVariantArray() {
            return new Variant[]{new Variant(this.f_serverHandles), new Variant(this.f_clientHandles)};
        }
    }
}

