/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.core.OptionSet;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.OptionSetStructure;
import com.prosysopc.ua.typedictionary.OptionSetStructureSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Optional;

public class DynamicOptionSetStructure
extends DynamicStructure
implements OptionSetStructure {
    public static Builder builder(OptionSetStructureSpecification optionSetStructureSpecification) {
        return new Builder(new DynamicOptionSetStructure(optionSetStructureSpecification));
    }

    public DynamicOptionSetStructure(OptionSetStructureSpecification optionSetStructureSpecification) {
        super(optionSetStructureSpecification);
    }

    @Override
    public DynamicOptionSetStructure clone() {
        return (DynamicOptionSetStructure)super.clone();
    }

    @Override
    public Object getValue() {
        return this.get("Value");
    }

    @Override
    public boolean isBitSet(int n2) {
        ByteString byteString = (ByteString)this.getValue();
        if (byteString == null) {
            return false;
        }
        return byteString.isBitSet(n2);
    }

    @Override
    public void setValid(int n2, boolean bl) {
        Optional<OptionSpecification> optional = this.specification().getOptions().stream().filter(optionSpecification -> optionSpecification.getBitPosition() == n2).findFirst();
        if (optional.isPresent()) {
            this.setValid(optional.get(), bl);
        }
    }

    @Override
    public void setValid(OptionSpecification optionSpecification, boolean bl) {
        BitSet bitSet;
        if (optionSpecification == null) {
            return;
        }
        if (!this.specification().getOptions().contains(optionSpecification)) {
            return;
        }
        ByteString byteString = (ByteString)this.get(OptionSet.Fields.ValidBits.getName());
        BitSet bitSet2 = bitSet = byteString == null ? new BitSet() : byteString.toBitSet();
        if (bl) {
            bitSet.set(optionSpecification.getBitPosition());
        } else {
            bitSet.clear(optionSpecification.getBitPosition());
        }
        if (byteString == null) {
            this.set(OptionSet.Fields.ValidBits.getName(), (Object)ByteString.fromBitSet(bitSet));
        } else {
            this.set(OptionSet.Fields.ValidBits.getName(), (Object)ByteString.fromBitSet(bitSet, byteString.getLength()));
        }
    }

    @Override
    public OptionSetStructureSpecification specification() {
        return (OptionSetStructureSpecification)super.specification();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.clone());
    }

    public static class Builder
    extends DynamicStructure.Builder
    implements OptionSetStructure.Builder {
        protected Builder(DynamicOptionSetStructure dynamicOptionSetStructure) {
            super(dynamicOptionSetStructure);
        }

        @Override
        public Builder add(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null || optionSpecificationArray.length == 0) {
                return this;
            }
            return this.addAll(Arrays.asList(optionSpecificationArray));
        }

        @Override
        public Builder addAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                return this;
            }
            ByteString byteString = (ByteString)this.delegate.get("Value");
            BitSet bitSet = byteString == null ? new BitSet() : byteString.toBitSet();
            iterable.forEach(optionSpecification -> this.setValid((OptionSpecification)optionSpecification, true));
            for (OptionSpecification optionSpecification2 : iterable) {
                bitSet.set(optionSpecification2.getBitPosition());
            }
            if (byteString == null) {
                this.delegate.set("Value", (Object)ByteString.fromBitSet(bitSet));
            } else {
                this.delegate.set("Value", (Object)ByteString.fromBitSet(bitSet, byteString.getLength()));
            }
            return this;
        }

        @Override
        public DynamicOptionSetStructure build() {
            return (DynamicOptionSetStructure)super.build();
        }

        @Override
        public Builder clear() {
            this.delegate.clear();
            return this;
        }

        @Override
        public boolean contains(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null) {
                throw new IllegalArgumentException("Null array is not permitted");
            }
            return this.containsAll(Arrays.asList(optionSpecificationArray));
        }

        @Override
        public boolean containsAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                throw new IllegalArgumentException("Null Iterable is not permitted");
            }
            ByteString byteString = (ByteString)this.delegate.get("Value");
            for (OptionSpecification optionSpecification : iterable) {
                if (!this.isValid(optionSpecification)) {
                    return false;
                }
                if (byteString == null) {
                    return false;
                }
                if (byteString.isBitSet(optionSpecification.getBitPosition())) continue;
                return false;
            }
            return true;
        }

        @Override
        public Builder remove(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null || optionSpecificationArray.length == 0) {
                return this;
            }
            return this.removeAll(Arrays.asList(optionSpecificationArray));
        }

        @Override
        public Builder removeAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                return this;
            }
            ByteString byteString = (ByteString)this.delegate.get("Value");
            if (byteString == null || byteString.getLength() == 0) {
                return this;
            }
            BitSet bitSet = byteString.toBitSet();
            iterable.forEach(optionSpecification -> this.setValid((OptionSpecification)optionSpecification, true));
            iterable.forEach(optionSpecification -> bitSet.clear(optionSpecification.getBitPosition()));
            this.delegate.set("Value", (Object)ByteString.fromBitSet(bitSet, byteString.getLength()));
            return this;
        }

        @Override
        public Builder setValid(int n2, boolean bl) {
            Optional<OptionSpecification> optional = this.specification().getOptions().stream().filter(optionSpecification -> optionSpecification.getBitPosition() == n2).findFirst();
            if (optional.isPresent()) {
                return this.setValid(optional.get(), bl);
            }
            return this;
        }

        @Override
        public Builder setValid(OptionSpecification optionSpecification, boolean bl) {
            BitSet bitSet;
            if (optionSpecification == null) {
                return this;
            }
            if (!this.specification().getOptions().contains(optionSpecification)) {
                return this;
            }
            ByteString byteString = (ByteString)this.get(OptionSet.Fields.ValidBits.getName());
            BitSet bitSet2 = bitSet = byteString == null ? new BitSet() : byteString.toBitSet();
            if (bl) {
                bitSet.set(optionSpecification.getBitPosition());
            } else {
                bitSet.clear(optionSpecification.getBitPosition());
            }
            if (byteString == null) {
                this.set(OptionSet.Fields.ValidBits.getName(), (Object)ByteString.fromBitSet(bitSet));
            } else {
                this.set(OptionSet.Fields.ValidBits.getName(), (Object)ByteString.fromBitSet(bitSet, byteString.getLength()));
            }
            return this;
        }

        @Override
        public OptionSetStructureSpecification specification() {
            return (OptionSetStructureSpecification)super.specification();
        }
    }
}

